/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2.status;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.features.status.api.Query;
import org.opennms.features.status.api.SeverityFilter;
import org.opennms.features.status.api.StatusSummary;
import org.opennms.features.status.api.application.ApplicationStatusService;
import org.opennms.features.status.api.bsm.BusinessServiceStatusService;
import org.opennms.features.status.api.node.NodeQuery;
import org.opennms.features.status.api.node.NodeStatusService;
import org.opennms.features.status.api.node.strategy.NodeStatusCalculationStrategy;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.rest.v2.status.model.ApplicationDTO;
import org.opennms.web.rest.v2.status.model.ApplicationDTOList;
import org.opennms.web.rest.v2.status.model.BusinessServiceDTO;
import org.opennms.web.rest.v2.status.model.BusinessServiceDTOList;
import org.opennms.web.rest.v2.status.model.NodeDTO;
import org.opennms.web.rest.v2.status.model.NodeDTOList;
import org.opennms.web.utils.QueryParameters;
import org.opennms.web.utils.QueryParametersBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="statusRestService")
@Path(value="status")
@Produces(value={"application/xml", "application/json"})
public class StatusRestService {
    @Autowired
    private BusinessServiceStatusService businessServiceStatusService;
    @Autowired
    private ApplicationStatusService applicationStatusService;
    @Autowired
    private NodeStatusService nodeStatusService;

    @GET
    @Path(value="/summary/nodes/{type}")
    public Response getNodeStatus(@PathParam(value="type") String type) {
        NodeStatusCalculationStrategy strategy = NodeStatusCalculationStrategy.createFrom((String)type);
        if (strategy == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Strategy '" + type + "' not supported. Supported values are:" + Arrays.toString(NodeStatusCalculationStrategy.values()))).build();
        }
        StatusSummary summary = this.nodeStatusService.getSummary(strategy);
        return Response.ok().entity(StatusRestService.convert(summary)).build();
    }

    @GET
    @Path(value="/summary/applications")
    public List<Object[]> getApplicationStatus() {
        StatusSummary summary = this.applicationStatusService.getSummary();
        return StatusRestService.convert(summary);
    }

    @GET
    @Path(value="/summary/business-services")
    public List<Object[]> getBusinessServiceStatus() {
        StatusSummary summary = this.businessServiceStatusService.getSummary();
        return StatusRestService.convert(summary);
    }

    @GET
    @Path(value="/applications")
    public Response getApplications(@Context UriInfo uriInfo) {
        QueryParameters queryParameters = QueryParametersBuilder.buildFrom((UriInfo)uriInfo);
        SeverityFilter severityFilter = StatusRestService.getSeverityFilter(uriInfo);
        Query query = new Query(queryParameters, severityFilter);
        List applications = this.applicationStatusService.getStatus(query);
        int totalCount = this.applicationStatusService.count(query);
        int offset = queryParameters.getOffset();
        List statusEntities = applications.stream().map(a -> {
            ApplicationDTO dto = new ApplicationDTO();
            dto.setId(((OnmsApplication)a.getEntity()).getId());
            dto.setName(((OnmsApplication)a.getEntity()).getName());
            dto.setSeverity(a.getStatus());
            return dto;
        }).collect(Collectors.toList());
        ApplicationDTOList list = new ApplicationDTOList(statusEntities);
        list.setOffset(queryParameters.getOffset());
        list.setTotalCount(totalCount);
        return StatusRestService.createResponse(list, offset, totalCount);
    }

    @GET
    @Path(value="/business-services")
    public Response getBusinessServices(@Context UriInfo uriInfo) {
        QueryParameters queryParameters = QueryParametersBuilder.buildFrom((UriInfo)uriInfo);
        SeverityFilter severityFilter = StatusRestService.getSeverityFilter(uriInfo);
        Query query = new Query(queryParameters, severityFilter);
        List services = this.businessServiceStatusService.getStatus(query);
        int totalCount = this.businessServiceStatusService.count(query);
        int offset = queryParameters.getOffset();
        List statusEntities = services.stream().map(bs -> {
            BusinessServiceDTO statusDTO = new BusinessServiceDTO();
            statusDTO.setId(((BusinessService)bs.getEntity()).getId().intValue());
            statusDTO.setName(((BusinessService)bs.getEntity()).getName());
            statusDTO.setSeverity(bs.getStatus());
            return statusDTO;
        }).collect(Collectors.toList());
        BusinessServiceDTOList list = new BusinessServiceDTOList(statusEntities);
        list.setOffset(queryParameters.getOffset());
        list.setTotalCount(totalCount);
        return StatusRestService.createResponse(list, offset, totalCount);
    }

    @GET
    @Path(value="/nodes/{type}")
    public Response getNodes(@Context UriInfo uriInfo, @PathParam(value="type") String type) {
        NodeStatusCalculationStrategy strategy = NodeStatusCalculationStrategy.createFrom((String)type);
        if (strategy == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Strategy '" + type + "' not supported. Supported values are:" + Arrays.toString(NodeStatusCalculationStrategy.values()))).build();
        }
        QueryParameters queryParameters = QueryParametersBuilder.buildFrom((UriInfo)uriInfo);
        SeverityFilter severityFilter = StatusRestService.getSeverityFilter(uriInfo);
        NodeQuery query = new NodeQuery(queryParameters, severityFilter);
        query.setStatusCalculationStrategy(strategy);
        if (query.getParameters().getOrder() != null && query.getParameters().getOrder().getColumn().equals("label")) {
            query.getParameters().setOrder(new QueryParameters.Order("node.nodelabel", query.getParameters().getOrder().isDesc()));
        }
        List nodes = this.nodeStatusService.getStatus(query);
        int totalCount = this.nodeStatusService.count(query);
        int offset = queryParameters.getOffset();
        List statusEntities = nodes.stream().map(node -> {
            NodeDTO nodeDTO = new NodeDTO();
            nodeDTO.setId(((OnmsNode)node.getEntity()).getId());
            nodeDTO.setName(((OnmsNode)node.getEntity()).getLabel());
            nodeDTO.setSeverity(node.getStatus());
            return nodeDTO;
        }).collect(Collectors.toList());
        NodeDTOList list = new NodeDTOList(statusEntities);
        list.setOffset(queryParameters.getOffset());
        list.setTotalCount(totalCount);
        return StatusRestService.createResponse(list, offset, totalCount);
    }

    private static List<Object[]> convert(StatusSummary statusSummary) {
        return StatusRestService.convert(statusSummary.getSeverityMap());
    }

    /*
     * Exception decompiling
     */
    private static List<Object[]> convert(Map<OnmsSeverity, Long> input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SeverityFilter getSeverityFilter(UriInfo uriInfo) {
        SeverityFilter severityFilter = new SeverityFilter();
        List severityFilterList = (List)uriInfo.getQueryParameters().get((Object)"severityFilter");
        if (severityFilterList != null) {
            for (String eachSeverity : severityFilterList) {
                OnmsSeverity severity = StatusRestService.getSeverity(eachSeverity);
                severityFilter.add(severity);
            }
        }
        return severityFilter;
    }

    private static OnmsSeverity getSeverity(String severityString) {
        if (!Strings.isNullOrEmpty((String)severityString)) {
            for (OnmsSeverity eachSeverity : OnmsSeverity.values()) {
                if (!eachSeverity.getLabel().equalsIgnoreCase(severityString)) continue;
                return eachSeverity;
            }
        }
        return null;
    }

    private static Response createResponse(JaxbListWrapper list, int offset, int totalCount) {
        if (list.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok((Object)list).header("Content-Range", (Object)String.format("items %d-%d/%d", offset, offset + list.size() - 1, totalCount)).build();
    }
}

