/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.status.api.node.strategy.query;

import java.math.BigInteger;
import org.opennms.features.status.api.node.strategy.NodeStatusCalculatorConfig;
import org.opennms.features.status.api.node.strategy.Status;
import org.opennms.features.status.api.node.strategy.query.Query;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;
import org.opennms.netmgt.model.OnmsSeverity;

public class AlarmQuery
extends Query {
    public AlarmQuery(GenericPersistenceAccessor genericPersistenceAccessor, NodeStatusCalculatorConfig config) {
        super(genericPersistenceAccessor, config);
    }

    @Override
    public Status status() {
        this.sql = new StringBuilder();
        this.sql.append("SELECT ").append(this.getViewName()).append(".nodeid").append(", ").append(this.getSeverityColumn()).append(" AS severity, alarm_count, alarm_count_unack ");
        this.sql.append("FROM ").append(this.getViewName()).append(" ");
        this.sql.append("JOIN node on ").append(this.getViewName()).append(".nodeid = node.nodeid ");
        this.applyRestrictions();
        this.applyOrder();
        this.applyLimitAndOffset();
        Status status = new Status();
        this.executeQuery(columns -> status.add((Integer)columns[0], OnmsSeverity.get((int)((Integer)columns[1])), columns[2] != null ? ((BigInteger)columns[2]).longValue() : 0L, columns[3] != null ? ((BigInteger)columns[3]).longValue() : 0L));
        return status;
    }

    @Override
    protected String getSeverityColumn() {
        if (this.config.isIncludeAcknowledgedAlarms()) {
            return "max_alarm_severity";
        }
        return "max_alarm_severity_unack";
    }

    @Override
    protected String getViewName() {
        return "node_alarm_status";
    }
}

