/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.status.api.node.strategy.query;

import java.util.Objects;
import org.opennms.features.status.api.node.strategy.NodeStatusCalculatorConfig;
import org.opennms.features.status.api.node.strategy.query.AlarmQuery;
import org.opennms.features.status.api.node.strategy.query.OutageQuery;
import org.opennms.features.status.api.node.strategy.query.Query;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;

public class QueryBuilder {
    private final GenericPersistenceAccessor gpa;

    public QueryBuilder(GenericPersistenceAccessor genericPersistenceAccessor) {
        this.gpa = Objects.requireNonNull(genericPersistenceAccessor);
    }

    public <T extends Query> T buildFrom(NodeStatusCalculatorConfig config) {
        switch (config.getCalculationStrategy()) {
            case Alarms: {
                return (T)new AlarmQuery(this.gpa, config);
            }
            case Outages: {
                return (T)new OutageQuery(this.gpa, config);
            }
        }
        throw new IllegalStateException("Query for CalculationStrategy is not implemented.");
    }
}

