/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.status.api.node.strategy.query;

import com.google.common.base.Strings;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.status.api.node.strategy.NodeStatusCalculatorConfig;
import org.opennms.features.status.api.node.strategy.Status;
import org.opennms.features.status.api.node.strategy.query.RowHandler;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.utils.QueryParameters;

public abstract class Query {
    protected final Map<String, Object> parameterMap = new HashMap<String, Object>();
    protected StringBuilder sql = new StringBuilder();
    protected final NodeStatusCalculatorConfig config;
    private final GenericPersistenceAccessor genericPersistenceAccessor;

    public Query(GenericPersistenceAccessor genericPersistenceAccessor, NodeStatusCalculatorConfig config) {
        this.config = Objects.requireNonNull(config);
        this.genericPersistenceAccessor = Objects.requireNonNull(genericPersistenceAccessor);
    }

    public int count() {
        this.sql = new StringBuilder();
        this.sql.append("SELECT count(*) ");
        this.sql.append("FROM ").append(this.getViewName()).append(" ");
        this.sql.append("JOIN node ON ").append(this.getViewName()).append(".nodeid = node.nodeid ");
        this.applyRestrictions();
        int count = this.executeQuerySingleResult(column -> ((BigInteger)column).intValue());
        return count;
    }

    public Map<OnmsSeverity, Long> overview() {
        this.sql = new StringBuilder();
        this.sql.append(String.format("SELECT count(*), %s as severity ", this.getSeverityColumn()));
        this.sql.append("FROM ").append(this.getViewName()).append(" ");
        this.sql.append("JOIN node on ").append(this.getViewName()).append(".nodeid = node.nodeid ");
        this.applyRestrictions();
        this.sql.append("GROUP BY severity ");
        this.applyLimitAndOffset();
        HashMap<OnmsSeverity, Long> statusMap = new HashMap<OnmsSeverity, Long>();
        this.executeQuery(columns -> statusMap.put(OnmsSeverity.get((int)((Integer)columns[1])), ((BigInteger)columns[0]).longValue()));
        return statusMap;
    }

    protected void applyLimitAndOffset() {
        if (this.config.getLimit() != null) {
            this.sql.append(String.format(" LIMIT %d", this.config.getLimit()));
        }
        if (this.config.getOffset() != null) {
            this.sql.append(String.format(" OFFSET %d", this.config.getOffset()));
        }
    }

    protected void applyOrder() {
        if (this.config.getOrder() != null && !Strings.isNullOrEmpty((String)this.config.getOrder().getColumn())) {
            QueryParameters.Order order = this.config.getOrder();
            this.sql.append(String.format("ORDER BY %s %s ", order.getColumn(), order.isDesc() ? "desc" : "asc"));
        }
    }

    protected void applyRestrictions() {
        this.sql.append("WHERE 1=1 ");
        if (!this.config.getNodeIds().isEmpty()) {
            this.sql.append(String.format("AND %s.nodeid IN (:nodeIds) ", this.getViewName()));
            this.parameterMap.put("nodeIds", this.config.getNodeIds());
        }
        if (this.config.getLocation() != null) {
            this.sql.append("AND node.location = :nodeLocation ");
            this.parameterMap.put("nodeLocation", this.config.getLocation());
        }
        if (this.config.getSeverities() != null && !this.config.getSeverities().isEmpty()) {
            this.sql.append(String.format("AND %s IN (:severities) ", this.getSeverityColumn()));
            this.parameterMap.put("severities", this.config.getSeverities().stream().map(s -> s.getId()).collect(Collectors.toList()));
        }
    }

    protected NodeStatusCalculatorConfig getConfig() {
        return this.config;
    }

    protected <T> void executeQuery(RowHandler<T> rowHandler) {
        List rows = this.genericPersistenceAccessor.executeNativeQuery(this.sql.toString(), this.parameterMap);
        if (rows != null && !rows.isEmpty()) {
            for (Object eachRow : rows) {
                rowHandler.handle(eachRow);
            }
        }
    }

    protected <T, X> X executeQuerySingleResult(Function<T, X> function) {
        List rows = this.genericPersistenceAccessor.executeNativeQuery(this.sql.toString(), this.parameterMap);
        if (rows == null || rows.size() != 1) {
            throw new IllegalStateException("Query returned multiple rows, but only 1 expected");
        }
        Object column = rows.get(0);
        return function.apply(column);
    }

    public abstract Status status();

    protected abstract String getSeverityColumn();

    protected abstract String getViewName();
}

