/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.AGateway;
import org.smslib.IUSSDNotification;
import org.smslib.USSDResponse;

public class UssdNotificationDispatcher
implements IUSSDNotification {
    private static Logger log = LoggerFactory.getLogger(UssdNotificationDispatcher.class);
    private Collection<IUSSDNotification> m_listenerList;

    public UssdNotificationDispatcher() {
    }

    public UssdNotificationDispatcher(List<IUSSDNotification> listeners) {
        this.m_listenerList = listeners;
    }

    public void process(AGateway gateway, USSDResponse ussdResponse) {
        log.debug("Forwarding message to registered listeners: {} : {}", this.getListeners(), (Object)ussdResponse);
        for (IUSSDNotification listener : this.getListeners()) {
            if (listener == this) continue;
            listener.process(gateway, ussdResponse);
        }
    }

    private Collection<IUSSDNotification> getListeners() {
        return this.m_listenerList;
    }

    public void setListenerList(List<IUSSDNotification> list) {
        this.m_listenerList = list;
    }
}

