/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.util.Arrays;
import org.opennms.sms.reflector.smsservice.GatewayGroup;
import org.opennms.sms.reflector.smsservice.OnmsInboundMessageNotification;
import org.opennms.sms.reflector.smsservice.SmsService;
import org.opennms.sms.reflector.smsservice.internal.SmsServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.AGateway;
import org.smslib.IGatewayStatusNotification;
import org.smslib.IOutboundMessageNotification;
import org.smslib.Service;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class SmsServiceListFactoryBean
implements FactoryBean<SmsService[]>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SmsServiceListFactoryBean.class);
    private GatewayGroup[] m_gatewayGroups;
    private SmsService[] m_services;
    private IOutboundMessageNotification m_outboundMessageNotification;
    private OnmsInboundMessageNotification m_inboundMessageNotification;
    private IGatewayStatusNotification m_gatewayStatusNotification;

    public void setOutboundMessageNotification(IOutboundMessageNotification mOutboundMessageNotification) {
        this.m_outboundMessageNotification = mOutboundMessageNotification;
    }

    public void setInboundMessageNotification(OnmsInboundMessageNotification mInboundMessageNotification) {
        this.m_inboundMessageNotification = mInboundMessageNotification;
    }

    public void setGatewayStatusNotification(IGatewayStatusNotification mGatewayStatusNotification) {
        this.m_gatewayStatusNotification = mGatewayStatusNotification;
    }

    public void setGatewayGroupList(GatewayGroup[] groupList) {
        this.m_gatewayGroups = Arrays.copyOf(groupList, groupList.length);
    }

    public void afterPropertiesSet() {
        this.m_services = new SmsService[this.m_gatewayGroups.length];
        int count = 0;
        for (GatewayGroup group : this.m_gatewayGroups) {
            AGateway[] gateways = group.getGateways();
            if (gateways.length == 0) {
                LOG.warn("A Gateway group was registered with ZERO gateways!");
                return;
            }
            SmsServiceImpl smsService = new SmsServiceImpl();
            smsService.setOutboundNotification(this.m_outboundMessageNotification);
            smsService.setInboundNotification(this.m_inboundMessageNotification);
            for (int i = 0; i < gateways.length; ++i) {
                try {
                    if (smsService.getServiceStatus() == Service.ServiceStatus.STARTED) {
                        smsService.stop();
                    }
                    smsService.addGateway(gateways[i]);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Unable to add gateway ({}) to SMS service", (Object)gateways[i], (Object)e);
                }
            }
            smsService.start();
            this.m_services[count++] = smsService;
        }
    }

    public SmsService[] getObject() throws Exception {
        return this.m_services;
    }

    public Class<? extends SmsService[]> getObjectType() {
        return SmsService[].class;
    }

    public boolean isSingleton() {
        return true;
    }
}

