/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.util.Collection;
import java.util.List;
import org.opennms.sms.reflector.smsservice.OnmsInboundMessageNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.AGateway;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class InboundMessageNotification
implements OnmsInboundMessageNotification {
    private static Logger log = LoggerFactory.getLogger(InboundMessageNotification.class);
    private Collection<OnmsInboundMessageNotification> m_listenerList;

    public InboundMessageNotification() {
    }

    public InboundMessageNotification(List<OnmsInboundMessageNotification> listeners) {
        this.m_listenerList = listeners;
    }

    public Collection<OnmsInboundMessageNotification> getListeners() {
        return this.m_listenerList;
    }

    @Override
    public void process(AGateway gateway, Message.MessageTypes msgType, InboundMessage msg) {
        this.deleteMessage(gateway, msg);
        for (OnmsInboundMessageNotification listener : this.getListeners()) {
            if (listener == this) continue;
            this.notifyListener(gateway, msgType, msg, listener);
        }
    }

    private void notifyListener(AGateway gateway, Message.MessageTypes msgType, InboundMessage msg, OnmsInboundMessageNotification listener) {
        try {
            listener.process(gateway, msgType, msg);
        }
        catch (Throwable e) {
            log.error("Unexpected exception processing InboundMessage {} listener: {}", new Object[]{msg, listener, e});
        }
    }

    private void deleteMessage(AGateway gateway, InboundMessage msg) {
        try {
            gateway.deleteMessage(msg);
        }
        catch (Throwable e) {
            log.error("Unable to delete message {}", (Object)msg, (Object)e);
        }
    }

    public void setListenerList(List<OnmsInboundMessageNotification> listeners) {
        this.m_listenerList = listeners;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }
}

