/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.util.Collection;
import java.util.List;
import org.smslib.AGateway;
import org.smslib.IGatewayStatusNotification;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GatewayStatusNotification
implements IGatewayStatusNotification,
ApplicationContextAware {
    private Collection<IGatewayStatusNotification> m_listenerList;
    private ApplicationContext m_applicationContext;

    public GatewayStatusNotification() {
    }

    public GatewayStatusNotification(List<IGatewayStatusNotification> listeners) {
        this.m_listenerList = listeners;
    }

    public void process(AGateway gateway, AGateway.GatewayStatuses oldStatus, AGateway.GatewayStatuses newStatus) {
        for (IGatewayStatusNotification listener : this.getListeners()) {
            if (listener == this) continue;
            listener.process(gateway, oldStatus, newStatus);
        }
    }

    private Collection<IGatewayStatusNotification> getListeners() {
        if (this.m_listenerList == null) {
            this.m_listenerList = this.m_applicationContext.getBeansOfType(IGatewayStatusNotification.class).values();
        }
        return this.m_listenerList;
    }

    public void setListenerList(List<IGatewayStatusNotification> list) {
        this.m_listenerList = list;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.m_applicationContext = applicationContext;
    }
}

