/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.AGateway;
import org.smslib.Service;

public class GatewayListener {
    private static final Logger LOG = LoggerFactory.getLogger(GatewayListener.class);
    private Service m_service;

    public void setService(Service service) {
        this.m_service = service;
    }

    public void addGateway(AGateway gateway, Map<?, ?> properties) {
        if (this.m_service != null) {
            try {
                if (this.m_service.getServiceStatus() == Service.ServiceStatus.STARTED) {
                    this.m_service.stopService();
                }
                this.m_service.addGateway(gateway);
                this.m_service.startService();
            }
            catch (Exception e) {
                LOG.warn("Unable to add gateway ({}) to SMS service", (Object)gateway, (Object)e);
            }
        }
    }

    public void removeGateway(AGateway gateway, Map<?, ?> properties) {
        if (this.m_service != null) {
            try {
                if (this.m_service.getServiceStatus() == Service.ServiceStatus.STARTED) {
                    this.m_service.stopService();
                }
                this.m_service.removeGateway(gateway);
                this.m_service.startService();
            }
            catch (Exception e) {
                LOG.warn("Unable to remove gateway ({}) from SMS service", (Object)gateway, (Object)e);
            }
        }
    }

    public void bind(Object arg0, Map<?, ?> arg1) throws Exception {
    }

    public void unbind(Object arg0, Map<?, ?> arg1) throws Exception {
    }
}

