/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.smsservice.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.sms.reflector.smsservice.GatewayGroup;
import org.opennms.sms.reflector.smsservice.OnmsInboundMessageNotification;
import org.opennms.sms.reflector.smsservice.internal.GatewayStatusNotification;
import org.opennms.sms.reflector.smsservice.internal.InboundMessageNotification;
import org.opennms.sms.reflector.smsservice.internal.OutboundMessageNotification;
import org.opennms.sms.reflector.smsservice.internal.SmsServiceImpl;
import org.opennms.sms.reflector.smsservice.internal.SmsServiceRegistrar;
import org.opennms.sms.reflector.smsservice.internal.UssdNotificationDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.AGateway;
import org.smslib.IGatewayStatusNotification;
import org.smslib.IOutboundMessageNotification;
import org.smslib.IUSSDNotification;
import org.smslib.Service;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class GatewayGroupListener
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(GatewayGroupListener.class);
    private SmsServiceRegistrar m_smsServiceRegistrar;
    private Map<GatewayGroup, SmsServiceImpl> m_services = new HashMap<GatewayGroup, SmsServiceImpl>();
    private List<IOutboundMessageNotification> m_outboundListeners;
    private List<OnmsInboundMessageNotification> m_inboundListeners;
    private List<IGatewayStatusNotification> m_gatewayStatusListeners;
    private List<IUSSDNotification> m_ussdListeners;

    public void onGatewayGroupRegistered(GatewayGroup gatewayGroup, Map<String, Object> properties) {
        AGateway[] gateways = gatewayGroup.getGateways();
        if (gateways.length == 0) {
            LOG.error("A Gateway group was registered with ZERO gateways!");
            return;
        }
        SmsServiceImpl smsService = new SmsServiceImpl();
        smsService.setOutboundNotification(new OutboundMessageNotification(this.getOutboundListeners()));
        smsService.setInboundNotification(new InboundMessageNotification(this.getInboundListeners()));
        smsService.setGatewayStatusNotification(new GatewayStatusNotification(this.getGatewayStatusListeners()));
        smsService.setUSSDNotification(new UssdNotificationDispatcher(this.getUssdListeners()));
        for (int i = 0; i < gateways.length; ++i) {
            try {
                if (smsService.getServiceStatus() == Service.ServiceStatus.STARTED) {
                    smsService.stop();
                }
                smsService.addGateway(gateways[i]);
                continue;
            }
            catch (Exception e) {
                LOG.warn("Unable to add gateway ({}) to SMS service", (Object)gateways[i], (Object)e);
            }
        }
        smsService.start();
        smsService.register(this.m_smsServiceRegistrar);
        this.m_services.put(gatewayGroup, smsService);
    }

    public void onGatewayGroupUnRegistered(GatewayGroup gatewayGroup, Map<?, ?> properties) {
        SmsServiceImpl service = this.m_services.get(gatewayGroup);
        service.unregister(this.m_smsServiceRegistrar);
        try {
            service.stop();
        }
        catch (Exception e) {
            LOG.warn("Unable to stop SMS service: {}", (Object)gatewayGroup, (Object)e);
        }
    }

    private boolean gatewayIdMatches(Collection<AGateway> gateways, AGateway[] aGateways) {
        for (AGateway serviceGateway : gateways) {
            for (AGateway groupGateway : aGateways) {
                if (serviceGateway.getGatewayId() != groupGateway.getGatewayId()) continue;
                return true;
            }
        }
        return false;
    }

    public void setOutboundListeners(List<IOutboundMessageNotification> outboundListeners) {
        this.m_outboundListeners = outboundListeners;
    }

    public List<IOutboundMessageNotification> getOutboundListeners() {
        return this.m_outboundListeners;
    }

    public void setInboundListeners(List<OnmsInboundMessageNotification> inboundListeners) {
        this.m_inboundListeners = inboundListeners;
    }

    public List<OnmsInboundMessageNotification> getInboundListeners() {
        return this.m_inboundListeners;
    }

    public void setGatewayStatusListeners(List<IGatewayStatusNotification> gatewayStatusListeners) {
        this.m_gatewayStatusListeners = gatewayStatusListeners;
    }

    public List<IGatewayStatusNotification> getGatewayStatusListeners() {
        return this.m_gatewayStatusListeners;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_smsServiceRegistrar, (String)"the smsServiceRegistrar must not be null");
    }

    public void setSmsServiceRegistrar(SmsServiceRegistrar smsServiceRegistrar) {
        this.m_smsServiceRegistrar = smsServiceRegistrar;
    }

    public SmsServiceRegistrar getSmsServiceRegistrar() {
        return this.m_smsServiceRegistrar;
    }

    public void setUssdListeners(List<IUSSDNotification> listeners) {
        this.m_ussdListeners = listeners;
    }

    public List<IUSSDNotification> getUssdListeners() {
        return this.m_ussdListeners;
    }
}

