/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.ping.internal;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.sms.reflector.smsservice.OnmsInboundMessageNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.InboundBinaryMessage;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.TimeoutException;

public class SmsPonger
implements OnmsInboundMessageNotification {
    private static final Logger LOG = LoggerFactory.getLogger(SmsPonger.class);
    Map<String, String> s_tokenResponses = SmsPonger.buildTokenResponses();

    public void process(AGateway gateway, Message.MessageTypes msgType, InboundMessage msg) {
        LOG.debug("SmsPonger.processInboundMessage");
        if (this.isPingRequest(msg)) {
            LOG.debug("Message is a ping request: {}", (Object)msg.getText());
            this.sendPong(gateway, msg);
        }
    }

    private boolean isPingRequest(InboundMessage msg) {
        return !(msg instanceof InboundBinaryMessage) && msg.getText() != null && (this.isPseudoPingRequest(msg) || this.isCanonicalPingRequest(msg));
    }

    private boolean isCanonicalPingRequest(InboundMessage msg) {
        return !(msg instanceof InboundBinaryMessage) && msg.getText() != null && msg.getText().length() >= 4 && "ping".equalsIgnoreCase(msg.getText().substring(0, 4));
    }

    private boolean isPseudoPingRequest(InboundMessage msg) {
        if (this.s_tokenResponses.size() == 0) {
            LOG.debug("No token responses found, not processing pseudo-pings");
            return false;
        }
        if (msg instanceof InboundBinaryMessage || msg.getText() == null) {
            return false;
        }
        for (String token : this.s_tokenResponses.keySet()) {
            if (!msg.getText().matches(token)) continue;
            return true;
        }
        return false;
    }

    private void sendPong(AGateway gateway, InboundMessage msg) {
        String pongResponse = this.isCanonicalPingRequest(msg) ? "pong" : this.getPseudoPongResponse(msg);
        LOG.debug("SmsPonger.sendPong: sending string '{}'", (Object)pongResponse);
        try {
            OutboundMessage pong = new OutboundMessage(msg.getOriginator(), pongResponse);
            pong.setGatewayId(gateway.getGatewayId());
            if (!gateway.sendMessage(pong)) {
                LOG.error("Failed to send pong request to {}", (Object)msg.getOriginator());
            }
        }
        catch (TimeoutException e) {
            LOG.error("Timeout sending pong request to {}", (Object)msg.getOriginator(), (Object)e);
        }
        catch (GatewayException e) {
            LOG.error("Gateway exception sending pong request to {}", (Object)msg.getOriginator(), (Object)e);
        }
        catch (IOException e) {
            LOG.error("IOException sending pong request to {}", (Object)msg.getOriginator(), (Object)e);
        }
        catch (InterruptedException e) {
            LOG.error("InterruptedException sending poing request to {}", (Object)msg.getOriginator(), (Object)e);
        }
    }

    private String getPseudoPongResponse(InboundMessage msg) {
        for (Map.Entry<String, String> tuple : this.s_tokenResponses.entrySet()) {
            if (!msg.getText().matches(tuple.getKey())) continue;
            return tuple.getValue();
        }
        LOG.debug("No pseudo-ping response found, defaulting to 'pong' (this should not happen)");
        return "";
    }

    private static Map<String, String> buildTokenResponses() {
        LinkedHashMap<String, String> tokenResponses = new LinkedHashMap<String, String>();
        String pseudoPingTokensPsv = System.getProperty("sms.ping.tokens", "");
        String pseudoPingResponsesPsv = System.getProperty("sms.ping.responses", "");
        String[] tokens = pseudoPingTokensPsv.split(";");
        String[] responses = pseudoPingResponsesPsv.split(";");
        if (tokens.length == 0) {
            LOG.debug("No pseudo-ping tokens defined");
            return tokenResponses;
        }
        if (tokens.length != responses.length) {
            LOG.error("Length of sms.ping.tokens ({}) is mismatched with length of sms.ping.responses ({})", (Object)tokens.length, (Object)responses.length);
            return tokenResponses;
        }
        for (int i = 0; i < tokens.length; ++i) {
            tokenResponses.put(tokens[i], responses[i]);
            LOG.debug("Setting response '{}' for pseudo-ping token '{}'", (Object)responses[i], (Object)tokens[i]);
        }
        return tokenResponses;
    }
}

