/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.ping.internal;

import java.io.IOException;
import org.opennms.protocols.rt.IDBasedRequestLocator;
import org.opennms.protocols.rt.Messenger;
import org.opennms.protocols.rt.RequestLocator;
import org.opennms.protocols.rt.RequestTracker;
import org.opennms.sms.ping.PingRequestId;
import org.opennms.sms.ping.PingResponseCallback;
import org.opennms.sms.ping.SmsPingTracker;
import org.opennms.sms.ping.internal.PingReply;
import org.opennms.sms.ping.internal.PingRequest;
import org.opennms.sms.ping.internal.SmsPingMessenger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsPingTrackerImpl
extends RequestTracker<PingRequest, PingReply>
implements SmsPingTracker {
    private static final Logger LOG = LoggerFactory.getLogger(SmsPingTrackerImpl.class);

    public SmsPingTrackerImpl(SmsPingMessenger smsMessenger) throws IOException {
        super("SMS", (Messenger)smsMessenger, (RequestLocator)new IDBasedRequestLocator());
        LOG.debug("Created SmsPingTrackerImpl");
    }

    @Override
    public void sendRequest(String phoneNumber, long timeout, int retries, PingResponseCallback cb) throws Exception {
        this.sendRequest(new PingRequest(new PingRequestId(phoneNumber), timeout, retries, cb));
    }

    public synchronized void start() {
        LOG.debug("Calling start()");
        super.start();
        LOG.debug("Called start()");
    }

    public void stop() {
        LOG.debug("Calling stop()");
        LOG.debug("Called stop()");
    }
}

