/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.ping.internal;

import java.io.IOException;
import java.util.Queue;
import org.opennms.protocols.rt.Messenger;
import org.opennms.sms.ping.internal.PingReply;
import org.opennms.sms.ping.internal.PingRequest;
import org.opennms.sms.reflector.smsservice.OnmsInboundMessageNotification;
import org.opennms.sms.reflector.smsservice.SmsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.AGateway;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class SmsPingMessenger
implements Messenger<PingRequest, PingReply>,
OnmsInboundMessageNotification,
InitializingBean {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private SmsService m_smsService;
    private Queue<PingReply> m_replyQueue;

    public void setSmsService(SmsService smsService) {
        this.m_smsService = smsService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_smsService, (String)"the smsService property must be set");
    }

    public void sendRequest(PingRequest request) throws Exception {
        request.setSentTimestamp(System.currentTimeMillis());
        this.debugf("SmsMessenger.sendRequest %s", request);
        if (!this.m_smsService.sendMessage(request.getRequest())) {
            throw new IOException("Failed to send sms message");
        }
    }

    public void start(Queue<PingReply> replyQueue) {
        this.debugf("SmsMessenger.start", new Object[0]);
        this.m_replyQueue = replyQueue;
    }

    public void process(AGateway gateway, Message.MessageTypes msgType, InboundMessage msg) {
        long receiveTime = System.currentTimeMillis();
        this.debugf("SmsMessenger.processInboundMessage", new Object[0]);
        if (this.m_replyQueue != null) {
            this.m_replyQueue.add(new PingReply(msg, receiveTime));
        }
    }

    private void debugf(String fmt, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format(fmt, args));
        }
    }
}

