/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.ping.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.opennms.sms.ping.PingResponseCallback;
import org.opennms.sms.ping.internal.PingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smslib.Message;

public class SinglePingResponseCallback
implements PingResponseCallback {
    private static final Logger LOG = LoggerFactory.getLogger(SinglePingResponseCallback.class);
    private CountDownLatch bs = new CountDownLatch(1);
    private Throwable error = null;
    private Long responseTime = null;
    private String m_phoneNumber;

    public SinglePingResponseCallback(String phoneNumber) {
        this.m_phoneNumber = phoneNumber;
    }

    @Override
    public void handleResponse(PingRequest request, Message packet) {
        LOG.info("got response for request {}, message = {}", (Object)request, (Object)packet);
        this.responseTime = request.getRoundTripTime();
        this.bs.countDown();
    }

    @Override
    public void handleTimeout(PingRequest request, Message packet) {
        LOG.info("timed out pinging request {}, message = {}", (Object)request, (Object)packet);
        this.bs.countDown();
    }

    @Override
    public void handleError(PingRequest request, Message pr, Throwable t) {
        LOG.info("an error occurred pinging {}", (Object)request, (Object)t);
        this.error = t;
        this.bs.countDown();
    }

    public void waitFor(long timeout) throws InterruptedException {
        this.bs.await(timeout, TimeUnit.MILLISECONDS);
    }

    public void waitFor() throws InterruptedException {
        LOG.info("waiting for ping to {} to finish", (Object)this.m_phoneNumber);
        this.bs.await();
        LOG.info("finished waiting for ping to {} to finish", (Object)this.m_phoneNumber);
    }

    public Long getResponseTime() {
        return this.responseTime;
    }
}

