/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.ping;

import java.io.IOException;
import org.opennms.sms.ping.PingResponseCallback;
import org.opennms.sms.ping.SmsPingTracker;
import org.opennms.sms.ping.internal.SinglePingResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsPinger {
    private static SmsPingTracker s_pingTracker;
    private static Logger log;

    public static synchronized void initialize() throws IOException {
        if (s_pingTracker == null) {
            throw new IllegalStateException("SmsPinger not yet initialized!!");
        }
    }

    public static synchronized void setSmsPingTracker(SmsPingTracker pingTracker) {
        log.debug("Initializing SmsPinger with pingTracker {}", (Object)pingTracker);
        s_pingTracker = pingTracker;
    }

    public static void ping(String phoneNumber, long timeout, int retries, PingResponseCallback cb) throws Exception {
        SmsPinger.initialize();
        s_pingTracker.sendRequest(phoneNumber, timeout, retries, cb);
    }

    public static Long ping(String phoneNumber, long timeout, int retries) throws InterruptedException, Exception {
        SinglePingResponseCallback cb = new SinglePingResponseCallback(phoneNumber);
        SmsPinger.ping(phoneNumber, timeout, retries, cb);
        cb.waitFor();
        return cb.getResponseTime();
    }

    public static Long ping(String host) throws Exception, InterruptedException {
        SinglePingResponseCallback cb = new SinglePingResponseCallback(host);
        SmsPinger.ping(host, 60000L, 2, cb);
        cb.waitFor();
        return cb.getResponseTime();
    }

    static {
        log = LoggerFactory.getLogger(SmsPinger.class);
    }
}

