/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.ping.internal;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.opennms.core.utils.LogUtils;
import org.opennms.sms.reflector.smsservice.OnmsInboundMessageNotification;
import org.smslib.AGateway;
import org.smslib.GatewayException;
import org.smslib.InboundBinaryMessage;
import org.smslib.InboundMessage;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.TimeoutException;

public class SmsPonger
implements OnmsInboundMessageNotification {
    Logger log = Logger.getLogger(this.getClass());
    Map<String, String> s_tokenResponses = SmsPonger.buildTokenResponses();

    public void process(AGateway gateway, Message.MessageTypes msgType, InboundMessage msg) {
        this.debugf("SmsPonger.processInboundMessage", new Object[0]);
        if (this.isPingRequest(msg)) {
            this.debugf("Message is a ping request: %s", msg.getText());
            this.sendPong(gateway, msg);
        }
    }

    private boolean isPingRequest(InboundMessage msg) {
        return !(msg instanceof InboundBinaryMessage) && msg.getText() != null && (this.isPseudoPingRequest(msg) || this.isCanonicalPingRequest(msg));
    }

    private boolean isCanonicalPingRequest(InboundMessage msg) {
        return !(msg instanceof InboundBinaryMessage) && msg.getText() != null && msg.getText().length() >= 4 && "ping".equalsIgnoreCase(msg.getText().substring(0, 4));
    }

    private boolean isPseudoPingRequest(InboundMessage msg) {
        if (this.s_tokenResponses.size() == 0) {
            this.debugf("No token responses found, not processing pseudo-pings", new Object[0]);
            return false;
        }
        if (msg instanceof InboundBinaryMessage || msg.getText() == null) {
            return false;
        }
        for (String token : this.s_tokenResponses.keySet()) {
            if (!msg.getText().matches(token)) continue;
            return true;
        }
        return false;
    }

    private void sendPong(AGateway gateway, InboundMessage msg) {
        String pongResponse = this.isCanonicalPingRequest(msg) ? "pong" : this.getPseudoPongResponse(msg);
        this.debugf("SmsPonger.sendPong: sending string '%s'", pongResponse);
        try {
            OutboundMessage pong = new OutboundMessage(msg.getOriginator(), pongResponse);
            pong.setGatewayId(gateway.getGatewayId());
            if (!gateway.sendMessage(pong)) {
                this.errorf("Failed to send pong request to %s", msg.getOriginator());
            }
        }
        catch (TimeoutException e) {
            this.errorf(e, "Timeout sending pong request to %s", msg.getOriginator());
        }
        catch (GatewayException e) {
            this.errorf(e, "Gateway exception sending pong request to %s", msg.getOriginator());
        }
        catch (IOException e) {
            this.errorf(e, "IOException sending pong request to %s", msg.getOriginator());
        }
        catch (InterruptedException e) {
            this.errorf(e, "InterruptedException sending poing request to %s", msg.getOriginator());
        }
    }

    private String getPseudoPongResponse(InboundMessage msg) {
        for (Map.Entry<String, String> tuple : this.s_tokenResponses.entrySet()) {
            if (!msg.getText().matches(tuple.getKey())) continue;
            return tuple.getValue();
        }
        this.debugf("No pseudo-ping response found, defaulting to 'pong' (this should not happen)", new Object[0]);
        return "";
    }

    private static Map<String, String> buildTokenResponses() {
        LinkedHashMap<String, String> tokenResponses = new LinkedHashMap<String, String>();
        String pseudoPingTokensPsv = System.getProperty("sms.ping.tokens", "");
        String pseudoPingResponsesPsv = System.getProperty("sms.ping.responses", "");
        String[] tokens = pseudoPingTokensPsv.split(";");
        String[] responses = pseudoPingResponsesPsv.split(";");
        if (tokens.length == 0) {
            LogUtils.debugf(SmsPonger.class, (String)"No pseudo-ping tokens defined", (Object[])new Object[0]);
            return tokenResponses;
        }
        if (tokens.length != responses.length) {
            LogUtils.errorf(SmsPonger.class, (String)"Length of sms.ping.tokens (%d) is mismatched with length of sms.ping.responses (%d)", (Object[])new Object[]{tokens.length, responses.length});
            return tokenResponses;
        }
        for (int i = 0; i < tokens.length; ++i) {
            tokenResponses.put(tokens[i], responses[i]);
            LogUtils.debugf(SmsPonger.class, (String)"Setting response '%s' for pseudo-ping token '%s'", (Object[])new Object[]{responses[i], tokens[i]});
        }
        return tokenResponses;
    }

    private void debugf(String fmt, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format(fmt, args));
        }
    }

    private void errorf(Throwable t, String fmt, Object ... args) {
        this.log.error((Object)String.format(fmt, args), t);
    }

    private void errorf(String fmt, Object ... args) {
        this.log.error((Object)String.format(fmt, args));
    }
}

