/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor.internal.config;

import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.sms.monitor.MobileSequenceSession;
import org.opennms.sms.monitor.internal.config.MobileSequenceConfig;
import org.opennms.sms.monitor.internal.config.MobileSequenceRequest;
import org.opennms.sms.monitor.internal.config.MobileSequenceResponse;
import org.opennms.sms.monitor.internal.config.TriggeredList;
import org.opennms.sms.reflector.smsservice.MobileMsgRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponse;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseHandler;

@XmlRootElement(name="transaction")
@XmlType(propOrder={"request", "responses"})
public class MobileSequenceTransaction
implements Comparable<MobileSequenceTransaction> {
    private MobileSequenceConfig m_sequenceConfig;
    private String m_label;
    private String m_gatewayId;
    private MobileSequenceRequest m_request;
    private List<MobileSequenceResponse> m_responses;
    private String m_defaultGatewayId;

    public MobileSequenceTransaction() {
    }

    public MobileSequenceTransaction(String label) {
        this.setLabel(label);
    }

    public MobileSequenceTransaction(String gatewayId, String label) {
        this(label);
        this.setGatewayId(gatewayId);
    }

    @XmlAttribute(name="label", required=true)
    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    @XmlAttribute(name="gatewayId", required=false)
    public String getGatewayId() {
        return this.m_gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.m_gatewayId = gatewayId;
    }

    @XmlElementRef
    public MobileSequenceRequest getRequest() {
        return this.m_request;
    }

    public void setRequest(MobileSequenceRequest request) {
        if (this.m_request != null) {
            this.m_request.setTransaction(null);
        }
        this.m_request = request;
        if (request != null) {
            request.setTransaction(this);
        }
    }

    @XmlElementRef
    public List<MobileSequenceResponse> getResponses() {
        if (this.m_responses == null) {
            this.m_responses = this.createResponsesList();
        }
        return this.m_responses;
    }

    private List<MobileSequenceResponse> createResponsesList() {
        return new TriggeredList<MobileSequenceResponse>(){

            @Override
            protected void onAdd(int index, MobileSequenceResponse element) {
                element.setTransaction(MobileSequenceTransaction.this);
            }

            @Override
            protected void onRemove(int index, MobileSequenceResponse element) {
                element.setTransaction(null);
            }
        };
    }

    public synchronized void setResponses(List<MobileSequenceResponse> responses) {
        if (this.m_responses == responses) {
            return;
        }
        this.m_responses.clear();
        this.m_responses.addAll(responses);
    }

    public void addResponse(MobileSequenceResponse response) {
        this.getResponses().add(response);
    }

    @XmlTransient
    public MobileSequenceConfig getSequenceConfig() {
        return this.m_sequenceConfig;
    }

    public void setSequenceConfig(MobileSequenceConfig sequenceConfig) {
        this.m_sequenceConfig = sequenceConfig;
    }

    @XmlTransient
    public String getDefaultGatewayId() {
        return this.m_defaultGatewayId;
    }

    public void setDefaultGatewayId(String gatewayId) {
        this.m_defaultGatewayId = gatewayId;
    }

    public String getLabel(MobileSequenceSession session) {
        return session.substitute(this.getRequest().getLabel(this.getLabel()));
    }

    @Override
    public int compareTo(MobileSequenceTransaction o) {
        return new CompareToBuilder().append((Object)this.getRequest(), (Object)o.getRequest()).append(this.getResponses(), o.getResponses()).toComparison();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("label", (Object)this.getLabel()).append("gatewayId", (Object)this.getGatewayId()).append("request", (Object)this.getRequest()).append("response(s)", this.getResponses()).toString();
    }

    public void sendRequest(MobileSequenceSession session, MobileMsgResponseHandler responseHandler) {
        this.getRequest().send(session, responseHandler);
    }

    public boolean matchesResponse(MobileSequenceSession session, MobileMsgRequest request, MobileMsgResponse response) {
        boolean match = false;
        for (MobileSequenceResponse r : this.getResponses()) {
            match = r.matches(session, request, response);
        }
        return match;
    }

    String getResponseLabel(MobileSequenceSession session, MobileSequenceResponse response) {
        return session.substitute(this.getLabel() + ".response" + this.getResponseIndex(response));
    }

    private int getResponseIndex(MobileSequenceResponse response) {
        int index = 1;
        for (MobileSequenceResponse r : this.getResponses()) {
            if (r == response) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException("response not found in transaction!");
    }
}

