/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor.internal.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.sms.monitor.MobileSequenceSession;
import org.opennms.sms.monitor.SequencerException;
import org.opennms.sms.monitor.internal.MobileSequenceExecution;
import org.opennms.sms.monitor.internal.config.MobileSequenceRequest;
import org.opennms.sms.monitor.internal.config.MobileSequenceResponse;
import org.opennms.sms.monitor.internal.config.MobileSequenceTransaction;
import org.opennms.sms.monitor.internal.config.SequenceSessionVariable;
import org.opennms.sms.monitor.internal.config.TriggeredList;
import org.springframework.util.Assert;

@XmlRootElement(name="mobile-sequence")
public class MobileSequenceConfig
implements Serializable,
Comparable<MobileSequenceConfig> {
    private static final long serialVersionUID = 142043644615784730L;
    private List<SequenceSessionVariable> m_sessionVariables;
    private List<MobileSequenceTransaction> m_transactions;

    public void addSessionVariable(SequenceSessionVariable var) {
        this.getSessionVariables().add(var);
    }

    @XmlElement(name="session-variable")
    public List<SequenceSessionVariable> getSessionVariables() {
        if (this.m_sessionVariables == null) {
            this.m_sessionVariables = this.createSessionVariableList();
        }
        return this.m_sessionVariables;
    }

    private List<SequenceSessionVariable> createSessionVariableList() {
        return Collections.synchronizedList(new ArrayList());
    }

    public void setSessionVariables(List<SequenceSessionVariable> sessionVariables) {
        this.m_sessionVariables = sessionVariables;
    }

    public void addTransaction(MobileSequenceTransaction transaction) {
        this.getTransactions().add(transaction);
    }

    @XmlElement(name="transaction")
    public List<MobileSequenceTransaction> getTransactions() {
        if (this.m_transactions == null) {
            this.m_transactions = this.createTransactionList();
        }
        return this.m_transactions;
    }

    private List<MobileSequenceTransaction> createTransactionList() {
        return new TriggeredList<MobileSequenceTransaction>(){

            @Override
            protected void onAdd(int index, MobileSequenceTransaction element) {
                element.setSequenceConfig(MobileSequenceConfig.this);
            }

            @Override
            protected void onRemove(int index, MobileSequenceTransaction element) {
                element.setSequenceConfig(null);
            }
        };
    }

    public void setTransactions(List<MobileSequenceTransaction> transactions) {
        List<MobileSequenceTransaction> oldTransactions = this.getTransactions();
        if (oldTransactions == transactions) {
            return;
        }
        oldTransactions.clear();
        oldTransactions.addAll(transactions);
    }

    @Override
    public int compareTo(MobileSequenceConfig o) {
        return new CompareToBuilder().append(this.getTransactions(), o.getTransactions()).toComparison();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("transactions", this.getTransactions()).toString();
    }

    public void computeDefaultGateways() {
        String defaultGatewayId = "*";
        for (MobileSequenceTransaction t : this.getTransactions()) {
            if (t.getGatewayId() != null) {
                defaultGatewayId = t.getGatewayId();
            }
            t.setDefaultGatewayId(defaultGatewayId);
        }
    }

    public MobileSequenceTransaction createTransaction(MobileSequenceRequest request, MobileSequenceResponse response) {
        MobileSequenceTransaction t = new MobileSequenceTransaction();
        this.addTransaction(t);
        t.setRequest(request);
        t.addResponse(response);
        return t;
    }

    public Map<String, Number> executeSequence(MobileSequenceSession session, DefaultTaskCoordinator coordinator) throws SequencerException, Throwable {
        MobileSequenceExecution execution = this.start(session, coordinator);
        this.waitFor(session, execution);
        return execution.getResponseTimes();
    }

    public MobileSequenceExecution start(MobileSequenceSession session, DefaultTaskCoordinator coordinator) throws SequencerException {
        Assert.notNull((Object)coordinator);
        this.computeDefaultGateways();
        MobileSequenceExecution execution = this.createExecution();
        execution.start(session, coordinator);
        return execution;
    }

    private MobileSequenceExecution createExecution() {
        return new MobileSequenceExecution(this);
    }

    public void waitFor(MobileSequenceSession session, MobileSequenceExecution execution) throws InterruptedException, ExecutionException, Throwable {
        execution.waitFor();
        execution.updateResults(session);
    }

    public boolean hasTransactions() {
        return this.getTransactions() != null && this.getTransactions().size() != 0;
    }
}

