/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor.internal.config;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.tasks.DefaultTaskCoordinator;
import org.opennms.protocols.rt.Messenger;
import org.opennms.sms.monitor.MobileSequenceSession;
import org.opennms.sms.monitor.TestMessenger;
import org.opennms.sms.monitor.internal.MobileSequenceConfigBuilder;
import org.opennms.sms.monitor.internal.config.MobileSequenceTransaction;
import org.opennms.sms.reflector.smsservice.MobileMsgRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponse;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseHandler;
import org.opennms.sms.reflector.smsservice.MobileMsgTracker;
import org.opennms.sms.reflector.smsservice.MobileMsgTrackerImpl;
import org.smslib.USSDSessionStatus;

public class MobileMsgAsyncTest {
    private static final String PHONE_NUMBER = "+19195551212";
    public static final String TMOBILE_RESPONSE = "37.28 received on 08/31/09. For continued service through 10/28/09, please pay 79.56 by 09/28/09.    ";
    public static final String TMOBILE_USSD_MATCH = "^.*[\\d\\.]+ received on \\d\\d/\\d\\d/\\d\\d. For continued service through \\d\\d/\\d\\d/\\d\\d, please pay [\\d\\.]+ by \\d\\d/\\d\\d/\\d\\d.*$";
    TestMessenger m_messenger;
    MobileMsgTrackerImpl m_tracker;
    DefaultTaskCoordinator m_coordinator;

    @Before
    public void setUp() throws Exception {
        this.m_messenger = new TestMessenger();
        this.m_tracker = new MobileMsgTrackerImpl("test", (Messenger)this.m_messenger);
        this.m_tracker.start();
        this.m_coordinator = new DefaultTaskCoordinator("MobileMsgAsyncTest", (Executor)Executors.newSingleThreadExecutor((ThreadFactory)new LogPreservingThreadFactory("MobileMsgAsyncTest", 1, false)));
        System.err.println("=== STARTING TEST ===");
    }

    @Test
    public void testRawSmsPing() throws Exception {
        MobileSequenceSession session = new MobileSequenceSession((MobileMsgTracker)this.m_tracker);
        session.setTimeout(1000L);
        session.setRetries(0);
        MobileSequenceConfigBuilder bldr = new MobileSequenceConfigBuilder();
        MobileSequenceConfigBuilder.MobileSequenceTransactionBuilder smsTransBldr = bldr.smsRequest("SMS ping", "*", PHONE_NUMBER, "ping");
        smsTransBldr.expectSmsResponse().matching("^[Pp]ong$");
        MobileSequenceTransaction transaction = smsTransBldr.getTransaction();
        LatencyResponseHandler handler = new LatencyResponseHandler(session, transaction);
        transaction.sendRequest(session, (MobileMsgResponseHandler)handler);
        Thread.sleep(500L);
        this.m_messenger.sendTestResponse(PHONE_NUMBER, "pong");
        Assert.assertFalse((boolean)handler.failed());
        Assert.assertFalse((boolean)handler.timedOut());
        Assert.assertTrue((handler.getLatency() > 400L ? 1 : 0) != 0);
        System.err.println("testRawSmsPing(): latency = " + handler.getLatency());
    }

    @Test
    public void testRawUssdMessage() throws Exception {
        String gatewayId = "G";
        MobileSequenceSession session = new MobileSequenceSession((MobileMsgTracker)this.m_tracker);
        session.setTimeout(3000L);
        session.setRetries(0);
        MobileSequenceConfigBuilder bldr = new MobileSequenceConfigBuilder();
        MobileSequenceConfigBuilder.MobileSequenceTransactionBuilder transBldr = bldr.ussdRequest("USSD request", "*", "#225#");
        transBldr.expectUssdResponse().matching(TMOBILE_USSD_MATCH);
        MobileSequenceTransaction transaction = transBldr.getTransaction();
        LatencyResponseHandler handler = new LatencyResponseHandler(session, transaction);
        transaction.sendRequest(session, (MobileMsgResponseHandler)handler);
        Thread.sleep(500L);
        this.m_messenger.sendTestResponse("G", TMOBILE_RESPONSE, USSDSessionStatus.NO_FURTHER_ACTION_REQUIRED);
        Assert.assertFalse((boolean)handler.failed());
        Assert.assertFalse((boolean)handler.timedOut());
        Assert.assertTrue((handler.getLatency() > 400L ? 1 : 0) != 0);
        System.err.println("testRawUssdMessage(): latency = " + handler.getLatency());
    }

    private final class LatencyResponseHandler
    implements MobileMsgResponseHandler {
        private final MobileSequenceSession m_session;
        private final MobileSequenceTransaction m_transaction;
        private final CountDownLatch m_latch = new CountDownLatch(1);
        private final AtomicLong m_start = new AtomicLong();
        private final AtomicLong m_end = new AtomicLong();
        private final AtomicBoolean m_timedOut = new AtomicBoolean(false);
        private final AtomicBoolean m_failed = new AtomicBoolean(false);

        public LatencyResponseHandler(MobileSequenceSession session, MobileSequenceTransaction transaction) {
            this.m_session = session;
            this.m_transaction = transaction;
        }

        public void handleError(MobileMsgRequest request, Throwable t) {
            this.m_failed.set(true);
            this.m_latch.countDown();
        }

        public boolean handleResponse(MobileMsgRequest request, MobileMsgResponse packet) {
            this.m_start.set(request.getSentTime());
            this.m_end.set(packet.getReceiveTime());
            this.m_latch.countDown();
            return true;
        }

        public void handleTimeout(MobileMsgRequest request) {
            this.m_timedOut.set(true);
            this.m_latch.countDown();
        }

        public boolean matches(MobileMsgRequest request, MobileMsgResponse response) {
            return this.m_transaction.matchesResponse(this.m_session, request, response);
        }

        public boolean failed() throws InterruptedException {
            this.m_latch.await();
            return this.m_failed.get();
        }

        public boolean timedOut() throws InterruptedException {
            this.m_latch.await();
            return this.m_timedOut.get();
        }

        public long getLatency() throws InterruptedException {
            this.m_latch.await();
            return this.m_end.get() - this.m_start.get();
        }
    }
}

