/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.monitor;

import java.util.Date;
import java.util.Queue;
import org.opennms.protocols.rt.Messenger;
import org.opennms.sms.reflector.smsservice.MobileMsgRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponse;
import org.opennms.sms.reflector.smsservice.SmsResponse;
import org.opennms.sms.reflector.smsservice.UssdResponse;
import org.smslib.InboundMessage;
import org.smslib.USSDDcs;
import org.smslib.USSDResponse;
import org.smslib.USSDSessionStatus;

public class TestMessenger
implements Messenger<MobileMsgRequest, MobileMsgResponse> {
    protected Queue<MobileMsgResponse> m_q;

    public void sendRequest(MobileMsgRequest request) throws Exception {
        request.setSendTimestamp(System.currentTimeMillis());
    }

    public void start(Queue<MobileMsgResponse> q) {
        this.m_q = q;
    }

    public void sendTestResponse(MobileMsgResponse response) {
        this.m_q.offer(response);
    }

    public void sendTestResponse(InboundMessage msg) {
        this.sendTestResponse((MobileMsgResponse)new SmsResponse(msg, System.currentTimeMillis()));
    }

    public void sendTestResponse(String gatewayId, USSDResponse response) {
        this.sendTestResponse((MobileMsgResponse)new UssdResponse(gatewayId, response, System.currentTimeMillis()));
    }

    public USSDResponse sendTestResponse(String gatewayId, String content, USSDSessionStatus status) {
        USSDResponse r = new USSDResponse();
        r.setContent(content);
        r.setUSSDSessionStatus(status);
        r.setDcs(USSDDcs.UNSPECIFIED_7BIT);
        this.sendTestResponse(gatewayId, r);
        return r;
    }

    public InboundMessage sendTestResponse(String recipient, String text) {
        InboundMessage responseMsg = new InboundMessage(new Date(), recipient, text, 0, "0");
        this.sendTestResponse(responseMsg);
        return responseMsg;
    }
}

