/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.commands.internal;

import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opennms.sms.reflector.smsservice.SmsService;
import org.smslib.USSDRequest;

public class UssdCommands
implements CommandProvider {
    private SmsService m_service;

    public void setService(SmsService svc) {
        this.m_service = svc;
    }

    public void _ussdSend(CommandInterpreter intp) {
        String data = intp.nextArgument();
        String gwId = intp.nextArgument();
        if (data == null || gwId == null) {
            intp.println((Object)"usage: ussdSend <data> <gatewayID>");
        }
        intp.println((Object)("Data is : " + data));
        intp.println((Object)("Gateway ID is : " + gwId));
        USSDRequest req = new USSDRequest(data);
        req.setGatewayId(gwId);
        intp.println((Object)("USSD raw request: " + req.toString()));
        try {
            this.m_service.sendUSSDRequest(req, gwId);
        }
        catch (Throwable e) {
            intp.println((Object)("Exception sending USSD request: " + e.getMessage()));
            intp.printStackTrace(e);
        }
    }

    public String getHelp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("---USSD Commands---");
        buffer.append("\n\t").append("ussdSend <data> <gatewayID>");
        buffer.append("\n");
        return buffer.toString();
    }
}

