/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.commands.internal;

import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.sms.reflector.smsservice.MobileMsgRequest;
import org.opennms.sms.reflector.smsservice.MobileMsgResponse;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseCallback;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseMatcher;
import org.opennms.sms.reflector.smsservice.MobileMsgResponseMatchers;
import org.opennms.sms.reflector.smsservice.MobileMsgTracker;
import org.smslib.OutboundMessage;
import org.smslib.USSDRequest;

public class MsgTrackerCommands
implements CommandProvider {
    private MobileMsgTracker m_tracker;

    public void setMobileMsgTracker(MobileMsgTracker tracker) {
        this.m_tracker = tracker;
    }

    public void _trackSms(CommandInterpreter intp) {
        try {
            String recipient = intp.nextArgument();
            String text = intp.nextArgument();
            String regex = intp.nextArgument();
            if (recipient == null || text == null || regex == null) {
                intp.println((Object)"usage: trackSms <recipient> <msg> <response-regexp>");
                return;
            }
            OutboundMessage msg = new OutboundMessage(recipient, text);
            MsgCallback cb = new MsgCallback();
            this.m_tracker.sendSmsRequest(msg, 60000L, 0, (MobileMsgResponseCallback)cb, (MobileMsgResponseMatcher)new MsgMatcher(regex));
            cb.waitFor();
            intp.println((Object)("Response: " + cb.getResponse()));
        }
        catch (Throwable e) {
            intp.printStackTrace(e);
        }
    }

    public void _trackUssd(CommandInterpreter intp) {
        try {
            String gatewayId = intp.nextArgument();
            String text = intp.nextArgument();
            String regex = intp.nextArgument();
            if (gatewayId == null || text == null || regex == null) {
                intp.println((Object)"usage: trackUssd <gateway> <msg> <response-regexp>");
                return;
            }
            USSDRequest msg = new USSDRequest(text);
            msg.setGatewayId(gatewayId);
            MsgCallback cb = new MsgCallback();
            this.m_tracker.sendUssdRequest(msg, 60000L, 0, (MobileMsgResponseCallback)cb, (MobileMsgResponseMatcher)new MsgMatcher(regex));
            cb.waitFor();
            intp.println((Object)("Response: " + cb.getResponse()));
        }
        catch (Throwable e) {
            intp.printStackTrace(e);
        }
    }

    public String getHelp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("---Msg Tracker Commands---");
        buffer.append("\n\t").append("trackSms <recipient> <msg> <regexp>");
        buffer.append("\n\t").append("trackUssd <gateway> <msg> <regexp>");
        buffer.append("\n");
        return buffer.toString();
    }

    public static void tracef(String format, Object ... args) {
        ThreadCategory log = ThreadCategory.getInstance(MobileMsgResponseMatchers.class);
        if (log.isTraceEnabled()) {
            log.trace(String.format(format, args));
        }
    }

    private static class MsgMatcher
    implements MobileMsgResponseMatcher {
        String m_regex;

        public MsgMatcher(String regex) {
            this.m_regex = regex;
        }

        public boolean matches(MobileMsgRequest request, MobileMsgResponse response) {
            MsgTrackerCommands.tracef("Using regex: %s to match response: %s", this.m_regex, response);
            boolean retVal = response.getText().matches(this.m_regex);
            MsgTrackerCommands.tracef("Matching: %s for regex %s response %s", retVal, this.m_regex, response);
            return retVal;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("regex", (Object)this.m_regex).toString();
        }
    }

    private static class MsgCallback
    implements MobileMsgResponseCallback {
        MobileMsgResponse m_response;
        CountDownLatch m_latch = new CountDownLatch(1);

        private MsgCallback() {
        }

        public void handleError(MobileMsgRequest request, Throwable t) {
            t.printStackTrace();
            LogUtils.warnf((Object)this, (Throwable)t, (String)"failed request: %s", (Object[])new Object[]{request});
            this.m_latch.countDown();
        }

        public boolean handleResponse(MobileMsgRequest request, MobileMsgResponse response) {
            this.m_response = response;
            this.m_latch.countDown();
            return true;
        }

        public void handleTimeout(MobileMsgRequest request) {
            MsgTrackerCommands.tracef("Request %s timed out!", request);
            this.m_latch.countDown();
        }

        public void waitFor() throws InterruptedException {
            this.m_latch.await();
        }

        public MobileMsgResponse getResponse() {
            return this.m_response;
        }
    }
}

