/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.sms.reflector.commands.internal;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.sms.ping.SmsPinger;
import org.opennms.sms.reflector.commands.internal.GatewayGroupImpl;
import org.opennms.sms.reflector.smsservice.GatewayGroup;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.smslib.AGateway;
import org.smslib.ICallNotification;
import org.smslib.IGatewayStatusNotification;
import org.smslib.IInboundMessageNotification;
import org.smslib.IOutboundMessageNotification;
import org.smslib.InboundMessage;
import org.smslib.Library;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.Service;
import org.smslib.USSDRequest;
import org.smslib.helper.CommPortIdentifier;
import org.smslib.modem.ModemGateway;
import org.smslib.modem.SerialModemGateway;
import org.springframework.osgi.context.BundleContextAware;

public class SmsCommands
implements CommandProvider,
BundleContextAware {
    private Service m_service;
    private ConfigurationAdmin m_configAdmin;
    private BundleContext m_context;

    public SmsCommands(ConfigurationAdmin configAdmin) {
        this.m_configAdmin = configAdmin;
    }

    public void stopService() {
        if (this.m_service != null) {
            try {
                this.m_service.stopService();
            }
            catch (Exception e) {
                LogUtils.debugf((Object)this, (Throwable)e, (String)"Exception Stopping Service Occurred", (Object[])new Object[0]);
            }
        }
    }

    public void smsSend(OutboundMessage msg) {
        try {
            this.m_service.sendMessage(msg);
        }
        catch (Exception e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"error sending message (%s)", (Object[])new Object[]{msg});
        }
    }

    public List<InboundMessage> checkMessages() {
        ArrayList<InboundMessage> msgList = new ArrayList<InboundMessage>();
        try {
            this.m_service.readMessages(msgList, InboundMessage.MessageClasses.UNREAD);
        }
        catch (Exception e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"unable to check messages", (Object[])new Object[0]);
        }
        return msgList;
    }

    public Object _smsPing(CommandInterpreter intp) {
        try {
            Long latency = SmsPinger.ping((String)intp.nextArgument());
            if (latency == null) {
                intp.println((Object)"Ping Timedout");
            } else {
                intp.println((Object)("Ping roundtrip time: " + latency));
            }
        }
        catch (Exception e) {
            intp.printStackTrace((Throwable)e);
        }
        return null;
    }

    public Object _smsSend(CommandInterpreter intp) {
        String phoneno = intp.nextArgument();
        if (phoneno == null) {
            intp.print((Object)"usage: smsSend <port> <phonenumber> <msg>");
            return null;
        }
        String msgText = intp.nextArgument();
        if (msgText == null) {
            intp.print((Object)"usage: smsSend <port> <phonenumber> <msg>");
            return null;
        }
        intp.println((Object)("Phone is : " + phoneno));
        intp.println((Object)("Message Text is : " + msgText));
        try {
            this.debugf("Example: Send message from a serial gsm modem.", new Object[0]);
            this.debugf(Library.getLibraryDescription(), new Object[0]);
            this.debugf("Version: %s", Library.getLibraryVersion());
            OutboundMessage msg = new OutboundMessage(phoneno, msgText);
            this.m_service.sendMessage(msg);
            intp.println((Object)msg);
            Thread.sleep(2000L);
        }
        catch (Throwable e) {
            intp.println((Object)"Exception Sending Message: ");
            intp.printStackTrace(e);
        }
        return null;
    }

    public void unused_ussdSend(CommandInterpreter intp) {
        String data = intp.nextArgument();
        String gwId = intp.nextArgument();
        if (data == null || gwId == null) {
            intp.println((Object)"usage: ussdSend <data> <gatewayID>");
        }
        intp.println((Object)("Data is : " + data));
        intp.println((Object)("Gateway ID is : " + gwId));
        USSDRequest req = new USSDRequest(data);
        intp.println((Object)("USSD request to send: " + req.toString()));
        if (this.m_service == null) {
            intp.println((Object)"Service object is null, cannot send");
            return;
        }
        try {
            this.m_service.sendUSSDRequest(req, gwId);
        }
        catch (Throwable e) {
            intp.println((Object)("Exception sending USSD request: " + e.getMessage()));
            intp.printStackTrace(e);
        }
    }

    public Object _checkMessages(CommandInterpreter intp) {
        try {
            ArrayList msgList = new ArrayList();
            this.m_service.readMessages(msgList, InboundMessage.MessageClasses.UNREAD);
            for (InboundMessage msg : msgList) {
                intp.println((Object)msg);
            }
        }
        catch (Throwable e) {
            intp.printStackTrace(e);
        }
        return null;
    }

    public Object _listPorts(CommandInterpreter intp) {
        Enumeration commPorts = CommPortIdentifier.getPortIdentifiers();
        while (commPorts.hasMoreElements()) {
            CommPortIdentifier commPort = (CommPortIdentifier)commPorts.nextElement();
            this.debugf(commPort.getName(), new Object[0]);
        }
        return null;
    }

    public Enumeration<CommPortIdentifier> listPorts() {
        return CommPortIdentifier.getPortIdentifiers();
    }

    public Object _initializePort(CommandInterpreter intp) {
        String port = intp.nextArgument();
        if (port == null) {
            intp.print((Object)"please initialize port usage: initializePort <port>");
            return null;
        }
        try {
            OutboundNotification m_outboundNotification = new OutboundNotification();
            InboundNotification m_inboundNotification = new InboundNotification();
            CallNotification m_callNotification = new CallNotification();
            GatewayStatusNotification m_gatewayStatusNotification = new GatewayStatusNotification();
            this.m_service = new Service();
            SerialModemGateway gateway = new SerialModemGateway("modem." + port, port, 57600, "SonyEricsson", "W760");
            gateway.setProtocol(AGateway.Protocols.PDU);
            gateway.setInbound(true);
            gateway.setOutbound(true);
            gateway.setSimPin("0000");
            this.m_service.setOutboundNotification((IOutboundMessageNotification)m_outboundNotification);
            this.m_service.setInboundNotification((IInboundMessageNotification)m_inboundNotification);
            this.m_service.setCallNotification((ICallNotification)m_callNotification);
            this.m_service.setGatewayStatusNotification((IGatewayStatusNotification)m_gatewayStatusNotification);
            this.m_service.addGateway((AGateway)gateway);
            this.m_service.startService();
            this.printGatewayInfo((AGateway)gateway, intp);
        }
        catch (Throwable e) {
            intp.printStackTrace(e);
        }
        return null;
    }

    public Object _debug(CommandInterpreter intp) {
        intp.println((Object)("m_configAdmin is " + this.m_configAdmin));
        return null;
    }

    public Object _showConfigs(CommandInterpreter intp) {
        try {
            Configuration[] configs = this.m_configAdmin.listConfigurations(null);
            if (configs == null) {
                intp.println((Object)"No configurations found.");
            } else {
                for (Configuration config : configs) {
                    intp.printDictionary(config.getProperties(), "PID: " + config.getPid());
                }
            }
        }
        catch (Throwable e) {
            intp.printStackTrace(e);
        }
        return null;
    }

    public Object _configureSmsService(CommandInterpreter intp) {
        try {
            String id = intp.nextArgument();
            String port = intp.nextArgument();
            String baudRate = intp.nextArgument();
            String manufacturer = intp.nextArgument();
            String model = intp.nextArgument();
            String usage = intp.nextArgument();
            GatewayGroupImpl gatewayGroup = new GatewayGroupImpl();
            ArrayList<SerialModemGateway> gateways = new ArrayList<SerialModemGateway>();
            SerialModemGateway gateway = new SerialModemGateway("modem." + id, port, new Integer(baudRate).intValue(), manufacturer, model);
            gateway.setProtocol(AGateway.Protocols.PDU);
            gateway.setInbound(true);
            gateway.setOutbound(true);
            gateway.setSimPin("0000");
            gateways.add(gateway);
            gatewayGroup.setGateways(gateways.toArray(new AGateway[0]));
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("gatewayUsageType", usage);
            this.getBundleContext().registerService(GatewayGroup.class, (Object)gatewayGroup, properties);
        }
        catch (Throwable e) {
            intp.printStackTrace(e);
        }
        return null;
    }

    public Object _paxLog(CommandInterpreter intp) {
        try {
            String level = intp.nextArgument();
            String prefix = intp.nextArgument();
            Configuration config = this.m_configAdmin.getConfiguration("org.ops4j.pax.logging", null);
            Hashtable<String, String> properties = config.getProperties();
            if (level == null) {
                if (properties == null) {
                    intp.println((Object)"Not current configuration");
                } else {
                    intp.printDictionary((Dictionary)properties, "Current Configuration");
                }
                return null;
            }
            if (properties == null) {
                intp.println((Object)"Creating a new configuraiton");
                properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("log4j.rootLogger", "DEBUG, A1");
                ((Dictionary)properties).put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
                ((Dictionary)properties).put("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
                ((Dictionary)properties).put("log4j.appender.A1.layout.ConversionPattern", "%-4r [%t] %-5p %c %x - %m%n");
            } else {
                intp.println((Object)"Found an existing configuration");
                intp.printDictionary(properties, "Existing");
            }
            if (prefix == null) {
                intp.println((Object)("Setting default config to " + level));
                ((Dictionary)properties).put("log4j.rootLogger", level + ", A1");
            } else {
                intp.println((Object)("Setting log level for " + prefix + " to " + level));
                ((Dictionary)properties).put("log4j.logger." + prefix, level);
            }
            intp.println((Object)"Setting new log configuration");
            intp.printDictionary(properties, "New");
            config.update(properties);
        }
        catch (Throwable e) {
            intp.printStackTrace(e);
        }
        return null;
    }

    public String getHelp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("---Sms Commands---");
        buffer.append("\n\t").append("debug");
        buffer.append("\n\t").append("checkMessages");
        buffer.append("\n\t").append("configureSmsService <modemId> <port> <baudRate> <manufacturer> <model> <usage>");
        buffer.append("\n\t").append("initializePort <modemPort>");
        buffer.append("\n\t").append("listPorts");
        buffer.append("\n\t").append("paxLog ERROR|WARN|INFO|DEBUG [prefix]");
        buffer.append("\n\t").append("smsSend <phonenumber> <text>");
        buffer.append("\n");
        return buffer.toString();
    }

    private void printGatewayInfo(AGateway gw, CommandInterpreter intp) throws Exception {
        intp.println();
        intp.println((Object)gw);
        if (gw instanceof ModemGateway) {
            ModemGateway gateway = (ModemGateway)gw;
            intp.println();
            intp.println((Object)"Modem Information:");
            intp.println((Object)("  Manufacturer: " + gateway.getManufacturer()));
            intp.println((Object)("  Model: " + gateway.getModel()));
            intp.println((Object)("  Serial No: " + gateway.getSerialNo()));
            intp.println((Object)("  SIM IMSI: " + gateway.getImsi()));
            intp.println((Object)("  Signal Level: " + gateway.getSignalLevel() + "%"));
            intp.println((Object)("  Battery Level: " + gateway.getBatteryLevel() + "%"));
            intp.println();
        }
    }

    public void setBundleContext(BundleContext m_context) {
        this.m_context = m_context;
    }

    public BundleContext getBundleContext() {
        return this.m_context;
    }

    private void debugf(String format, Object ... args) {
        ThreadCategory log = ThreadCategory.getInstance(SmsCommands.class);
        if (log.isDebugEnabled()) {
            log.debug(String.format(format, args));
        }
    }

    public class GatewayStatusNotification
    implements IGatewayStatusNotification {
        public void process(String gatewayId, AGateway.GatewayStatuses oldStatus, AGateway.GatewayStatuses newStatus) {
            SmsCommands.this.debugf(">>> Gateway Status change from: %s, OLD:  %s -> NEW: %s", new Object[]{gatewayId, oldStatus, newStatus});
        }
    }

    public class CallNotification
    implements ICallNotification {
        public void process(String gatewayId, String callerId) {
            SmsCommands.this.debugf(">>> New called detected from Gateway: %s : %s", new Object[]{gatewayId, callerId});
        }
    }

    public class InboundNotification
    implements IInboundMessageNotification {
        public void process(String gatewayId, Message.MessageTypes msgType, InboundMessage msg) {
            if (msgType == Message.MessageTypes.INBOUND) {
                SmsCommands.this.debugf(">>> New Inbound message detected from Gateway: %s", new Object[]{gatewayId});
            } else if (msgType == Message.MessageTypes.STATUSREPORT) {
                SmsCommands.this.debugf(">>> New Inbound Status Report message detected from Gateway: %s", new Object[]{gatewayId});
            }
            SmsCommands.this.debugf("msg text: %s", new Object[]{msg.getText()});
        }
    }

    public class OutboundNotification
    implements IOutboundMessageNotification {
        public void process(String gatewayId, OutboundMessage msg) {
            SmsCommands.this.debugf("Outbound handler called from Gateway: %s", new Object[]{gatewayId});
            SmsCommands.this.debugf(msg.toString(), new Object[0]);
        }
    }
}

