/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.situationfeedback.rest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.WebApplicationException;
import org.opennms.features.situationfeedback.api.AlarmFeedback;
import org.opennms.features.situationfeedback.api.AlarmFeedbackListener;
import org.opennms.features.situationfeedback.api.FeedbackException;
import org.opennms.features.situationfeedback.api.FeedbackRepository;
import org.opennms.features.situationfeedback.rest.SituationFeedbackRestService;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmEntityNotifier;
import org.opennms.netmgt.model.OnmsAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionOperations;

public class SituationFeedbackRestServiceImpl
implements SituationFeedbackRestService {
    private static final Logger LOG = LoggerFactory.getLogger(SituationFeedbackRestServiceImpl.class);
    private final AlarmDao alarmDao;
    private final AlarmEntityNotifier alarmEntityNotifier;
    private final FeedbackRepository repository;
    private final TransactionOperations transactionTemplate;
    private static final Collection<AlarmFeedbackListener> alarmFeedbackListeners = new ArrayList<AlarmFeedbackListener>();

    public SituationFeedbackRestServiceImpl(AlarmDao alarmDao, AlarmEntityNotifier alarmEntityNotifier, FeedbackRepository feedbackRepository, TransactionOperations transactionOperations) {
        this.alarmDao = Objects.requireNonNull(alarmDao);
        this.alarmEntityNotifier = Objects.requireNonNull(alarmEntityNotifier);
        this.repository = Objects.requireNonNull(feedbackRepository);
        this.transactionTemplate = Objects.requireNonNull(transactionOperations);
    }

    public synchronized void onBind(AlarmFeedbackListener alarmFeedbackListener, Map properties) {
        LOG.debug("bind called with {}: {}", (Object)alarmFeedbackListener, (Object)properties);
        if (alarmFeedbackListener != null) {
            alarmFeedbackListeners.add(alarmFeedbackListener);
        }
    }

    public synchronized void onUnbind(AlarmFeedbackListener alarmFeedbackListener, Map properties) {
        LOG.debug("Unbind called with {}: {}", (Object)alarmFeedbackListener, (Object)properties);
        if (alarmFeedbackListener != null) {
            alarmFeedbackListeners.remove(alarmFeedbackListener);
        }
    }

    @Override
    public Collection<AlarmFeedback> getFeedback(int situationId) {
        try {
            return this.repository.getFeedback(this.getReductionKey(situationId));
        }
        catch (FeedbackException e) {
            LOG.error("Error retrieving alarm correlation feedback for [{}]: {}", (Object)situationId, (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    private String getReductionKey(int situationId) throws FeedbackException {
        OnmsAlarm situation = (OnmsAlarm)this.alarmDao.get((Serializable)Integer.valueOf(situationId));
        if (situation == null) {
            throw new FeedbackException("No Situation found with ID " + situationId);
        }
        return situation.getReductionKey();
    }

    @Override
    public void setFeedback(int situationId, List<AlarmFeedback> feedback) {
        try {
            this.repository.persist(feedback);
        }
        catch (Exception e) {
            throw new WebApplicationException("Failed to execute query: " + e.getMessage(), (Throwable)e);
        }
        alarmFeedbackListeners.forEach(listener -> {
            try {
                listener.handleAlarmFeedback((Collection)feedback);
            }
            catch (Exception e) {
                LOG.warn("Failed to notify listener of alarm feedback", (Throwable)e);
            }
        });
    }
}

