/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.situationfeedback.rest;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import org.opennms.features.situationfeedback.api.AlarmFeedback;
import org.opennms.features.situationfeedback.api.FeedbackException;
import org.opennms.features.situationfeedback.api.FeedbackRepository;
import org.opennms.features.situationfeedback.rest.SituationFeedbackRestService;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AlarmEntityNotifier;
import org.opennms.netmgt.model.OnmsAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class SituationFeedbackRestServiceImpl
implements SituationFeedbackRestService {
    private static final Logger Log = LoggerFactory.getLogger(SituationFeedbackRestServiceImpl.class);
    private final AlarmDao alarmDao;
    private final AlarmEntityNotifier alarmEntityNotifier;
    private final FeedbackRepository repository;
    private final TransactionOperations transactionTemplate;

    public SituationFeedbackRestServiceImpl(AlarmDao alarmDao, AlarmEntityNotifier alarmEntityNotifier, FeedbackRepository feedbackRepository, TransactionOperations transactionOperations) {
        this.alarmDao = Objects.requireNonNull(alarmDao);
        this.alarmEntityNotifier = Objects.requireNonNull(alarmEntityNotifier);
        this.repository = Objects.requireNonNull(feedbackRepository);
        this.transactionTemplate = Objects.requireNonNull(transactionOperations);
    }

    @Override
    public Collection<AlarmFeedback> getFeedback(int situationId) {
        try {
            return this.repository.getFeedback(this.getReductionKey(situationId));
        }
        catch (FeedbackException e) {
            Log.error("Error retrieving alarm correlation feedback for [{}]: {}", (Object)situationId, (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    private String getReductionKey(int situationId) throws FeedbackException {
        OnmsAlarm situation = (OnmsAlarm)this.alarmDao.get((Serializable)Integer.valueOf(situationId));
        if (situation == null) {
            throw new FeedbackException("No Situation found with ID " + situationId);
        }
        return situation.getReductionKey();
    }

    @Override
    public void setFeedback(int situationId, List<AlarmFeedback> feedback) {
        this.runInTransaction(status -> {
            feedback.stream().filter(f -> f.getFeedbackType() == AlarmFeedback.FeedbackType.FALSE_NEGATIVE).forEach(c -> SituationFeedbackRestServiceImpl.addCorrelation(c, this.alarmDao, this.alarmEntityNotifier));
            feedback.stream().filter(f -> f.getFeedbackType() == AlarmFeedback.FeedbackType.FALSE_POSITIVE).forEach(c -> SituationFeedbackRestServiceImpl.removeCorrelation(c, this.alarmDao, this.alarmEntityNotifier));
            try {
                this.repository.persist((Collection)feedback);
            }
            catch (Exception e) {
                throw new WebApplicationException("Failed to execute query: " + e.getMessage(), (Throwable)e);
            }
            return null;
        });
    }

    protected static void removeCorrelation(AlarmFeedback feedback, AlarmDao alarmDao, AlarmEntityNotifier alarmEntityNotifier) {
        OnmsAlarm situation = alarmDao.findByReductionKey(feedback.getSituationKey());
        OnmsAlarm alarm = alarmDao.findByReductionKey(feedback.getAlarmKey());
        if (situation == null || alarm == null) {
            return;
        }
        Set previousRelatedAlarms = situation.getRelatedAlarms();
        Log.debug("removing alarm {} from situation {}.", (Object)alarm, (Object)situation);
        situation.getRelatedAlarms().remove(alarm);
        alarmDao.saveOrUpdate((Object)situation);
        Log.debug("removed alarm {} from situation {}.", (Object)alarm, (Object)situation);
        alarmEntityNotifier.didUpdateRelatedAlarms(situation, previousRelatedAlarms);
    }

    protected static void addCorrelation(AlarmFeedback feedback, AlarmDao alarmDao, AlarmEntityNotifier alarmEntityNotifier) {
        OnmsAlarm situation = alarmDao.findByReductionKey(feedback.getSituationKey());
        OnmsAlarm alarm = alarmDao.findByReductionKey(feedback.getAlarmKey());
        if (situation == null || alarm == null) {
            return;
        }
        Set previousRelatedAlarms = situation.getRelatedAlarms();
        Log.debug("adding alarm {} to situation {}.", (Object)alarm, (Object)situation);
        situation.getRelatedAlarms().add(alarm);
        alarmDao.saveOrUpdate((Object)situation);
        Log.debug("added alarm {} to situation {}.", (Object)alarm, (Object)situation);
        alarmEntityNotifier.didUpdateRelatedAlarms(situation, previousRelatedAlarms);
    }

    private <T> T runInTransaction(TransactionCallback<T> callback) {
        return (T)this.transactionTemplate.execute(callback);
    }
}

