/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.situationfeedback.api;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Enums;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AlarmFeedback {
    private final String situationKey;
    private final String situationFingerprint;
    private final String alarmKey;
    private final FeedbackType feedbackType;
    private final String reason;
    private final String user;
    private final long timestamp;

    private AlarmFeedback(Builder builder) {
        this.situationKey = builder.situationKey;
        this.situationFingerprint = builder.situationFingerprint;
        this.alarmKey = builder.alarmKey;
        this.feedbackType = builder.feedbackType;
        this.reason = builder.reason;
        this.user = builder.user;
        this.timestamp = builder.timestamp;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSituationKey() {
        return this.situationKey;
    }

    public String getSituationFingerprint() {
        return this.situationFingerprint;
    }

    public String getAlarmKey() {
        return this.alarmKey;
    }

    public FeedbackType getFeedbackType() {
        return this.feedbackType;
    }

    public String getReason() {
        return this.reason;
    }

    public String getUser() {
        return this.user;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlarmFeedback that = (AlarmFeedback)o;
        return this.timestamp == that.timestamp && Objects.equals(this.situationKey, that.situationKey) && Objects.equals(this.situationFingerprint, that.situationFingerprint) && Objects.equals(this.alarmKey, that.alarmKey) && this.feedbackType == that.feedbackType && Objects.equals(this.reason, that.reason) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.situationKey, this.situationFingerprint, this.alarmKey, this.feedbackType, this.reason, this.user, this.timestamp});
    }

    public String toString() {
        return "AlarmFeedback{situationKey='" + this.situationKey + '\'' + ", situationFingerprint='" + this.situationFingerprint + '\'' + ", alarmKey='" + this.alarmKey + '\'' + ", feedbackType=" + (Object)((Object)this.feedbackType) + ", reason='" + this.reason + '\'' + ", user='" + this.user + '\'' + ", timestamp=" + this.timestamp + '}';
    }

    public static class Builder {
        private String situationKey;
        private String situationFingerprint;
        private String alarmKey;
        private FeedbackType feedbackType;
        private String reason;
        private String user;
        private Long timestamp = System.currentTimeMillis();

        public Builder withSituationKey(String situationKey) {
            this.situationKey = situationKey;
            return this;
        }

        public Builder withSituationFingerprint(String situationFingerprint) {
            this.situationFingerprint = situationFingerprint;
            return this;
        }

        public Builder withAlarmKey(String alarmKey) {
            this.alarmKey = alarmKey;
            return this;
        }

        public Builder withFeedbackType(FeedbackType feedbackType) {
            this.feedbackType = feedbackType;
            return this;
        }

        public Builder withReason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder withUser(String user) {
            this.user = user;
            return this;
        }

        public Builder withTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public AlarmFeedback build() {
            Objects.requireNonNull(this.situationKey, "The situation key cannot be null");
            Objects.requireNonNull(this.alarmKey, "The alarm key cannot be null");
            Objects.requireNonNull(this.feedbackType, "The feedback type cannot be null");
            Objects.requireNonNull(this.timestamp, "The timestamp cannot be null");
            return new AlarmFeedback(this);
        }
    }

    public static enum FeedbackType {
        FALSE_POSITIVE,
        FALSE_NEGATIVE,
        CORRECT,
        UNKNOWN;


        public static FeedbackType valueOfOrUnknown(String type) {
            return (FeedbackType)((Object)Enums.getIfPresent(FeedbackType.class, (String)type).or((Object)UNKNOWN));
        }
    }
}

