/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.situationfeedback.api;

import com.google.common.base.Enums;
import java.util.Objects;

public class AlarmFeedback {
    private final String situationKey;
    private final String situationFingerprint;
    private final String alarmKey;
    private final FeedbackType feedbackType;
    private final String reason;
    private final String user;
    private final long timestamp;

    private AlarmFeedback(Builder builder) {
        this.situationKey = builder.situationKey;
        this.situationFingerprint = builder.situationFingerprint;
        this.alarmKey = builder.alarmKey;
        this.feedbackType = builder.feedbackType;
        this.reason = builder.reason;
        this.user = builder.user;
        this.timestamp = builder.timestamp;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSituationKey() {
        return this.situationKey;
    }

    public String getSituationFingerprint() {
        return this.situationFingerprint;
    }

    public String getAlarmKey() {
        return this.alarmKey;
    }

    public FeedbackType getFeedbackType() {
        return this.feedbackType;
    }

    public String getReason() {
        return this.reason;
    }

    public String getUser() {
        return this.user;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "Feedback[" + (Object)((Object)this.getFeedbackType()) + ":" + this.getSituationKey() + ":" + this.getAlarmKey() + ":" + this.getReason() + "]";
    }

    public static class Builder {
        private String situationKey;
        private String situationFingerprint;
        private String alarmKey;
        private FeedbackType feedbackType;
        private String reason;
        private String user;
        private long timestamp = System.currentTimeMillis();

        private Builder() {
        }

        public Builder withSituationKey(String situationKey) {
            this.situationKey = situationKey;
            return this;
        }

        public Builder withSituationFingerprint(String situationFingerprint) {
            this.situationFingerprint = situationFingerprint;
            return this;
        }

        public Builder withAlarmKey(String alarmKey) {
            this.alarmKey = alarmKey;
            return this;
        }

        public Builder withFeedbackType(FeedbackType feedbackType) {
            this.feedbackType = feedbackType;
            return this;
        }

        public Builder withReason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder withUser(String user) {
            this.user = user;
            return this;
        }

        public Builder withTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public AlarmFeedback build() {
            Objects.requireNonNull(this.situationKey, "The situation key cannot be null");
            Objects.requireNonNull(this.alarmKey, "The alarm key cannot be null");
            Objects.requireNonNull(this.feedbackType, "The feedback type cannot be null");
            return new AlarmFeedback(this);
        }
    }

    public static enum FeedbackType {
        FALSE_POSITIVE,
        FALSE_NEGATIVE,
        CORRECT,
        UNKNOWN;


        public static FeedbackType valueOfOrUnknown(String type) {
            return (FeedbackType)((Object)Enums.getIfPresent(FeedbackType.class, (String)type).or((Object)UNKNOWN));
        }
    }
}

