/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic;

import com.google.common.collect.Table;
import io.searchbox.client.JestClient;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.opennms.netmgt.flows.api.ConversationKey;
import org.opennms.netmgt.flows.api.Directional;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.flows.api.FlowException;
import org.opennms.netmgt.flows.api.FlowRepository;
import org.opennms.netmgt.flows.api.FlowSource;
import org.opennms.netmgt.flows.api.TrafficSummary;
import org.opennms.netmgt.flows.elastic.ElasticFlowRepositoryInitializer;
import org.opennms.netmgt.flows.filter.api.Filter;
import org.opennms.plugins.elasticsearch.rest.template.IndexSettings;
import org.osgi.framework.BundleContext;

public class InitializingFlowRepository
implements FlowRepository {
    private final ElasticFlowRepositoryInitializer initializer;
    private final FlowRepository delegate;

    public InitializingFlowRepository(BundleContext bundleContext, FlowRepository delegate, JestClient client, IndexSettings indexSettings) {
        this(delegate, new ElasticFlowRepositoryInitializer(bundleContext, client, indexSettings));
    }

    protected InitializingFlowRepository(FlowRepository delegate, JestClient client) {
        this(delegate, new ElasticFlowRepositoryInitializer(client));
    }

    private InitializingFlowRepository(FlowRepository delegate, ElasticFlowRepositoryInitializer initializer) {
        this.delegate = Objects.requireNonNull(delegate);
        this.initializer = Objects.requireNonNull(initializer);
    }

    public void persist(Collection<Flow> flows, FlowSource source) throws FlowException {
        this.ensureInitialized();
        this.delegate.persist(flows, source);
    }

    public CompletableFuture<Long> getFlowCount(List<Filter> filters) {
        return this.delegate.getFlowCount(filters);
    }

    public CompletableFuture<List<TrafficSummary<String>>> getTopNApplications(int N, boolean includeOther, List<Filter> filters) {
        return this.delegate.getTopNApplications(N, includeOther, filters);
    }

    public CompletableFuture<Table<Directional<String>, Long, Double>> getTopNApplicationsSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.delegate.getTopNApplicationsSeries(N, step, includeOther, filters);
    }

    public CompletableFuture<List<TrafficSummary<ConversationKey>>> getTopNConversations(int N, List<Filter> filters) {
        return this.delegate.getTopNConversations(N, filters);
    }

    public CompletableFuture<Table<Directional<ConversationKey>, Long, Double>> getTopNConversationsSeries(int N, long step, List<Filter> filters) {
        return this.delegate.getTopNConversationsSeries(N, step, filters);
    }

    private void ensureInitialized() {
        if (!this.initializer.isInitialized()) {
            this.initializer.initialize();
        }
    }
}

