/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.rws;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.rws.BaseUrl;
import org.opennms.netmgt.config.rws.StandbyUrl;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="rws-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="rws-configuration.xsd")
public class RwsConfiguration
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="base-url", required=true)
    private BaseUrl m_baseUrl;
    @XmlElement(name="standby-url")
    private List<StandbyUrl> m_standbyUrls = new ArrayList<StandbyUrl>();

    public BaseUrl getBaseUrl() {
        return this.m_baseUrl;
    }

    public void setBaseUrl(BaseUrl baseUrl) {
        this.m_baseUrl = ConfigUtils.assertNotNull(baseUrl, "base-url");
    }

    public List<StandbyUrl> getStandbyUrls() {
        return this.m_standbyUrls;
    }

    public void setStandbyUrls(List<StandbyUrl> standbyUrls) {
        if (standbyUrls == this.m_standbyUrls) {
            return;
        }
        this.m_standbyUrls.clear();
        if (standbyUrls != null) {
            this.m_standbyUrls.addAll(standbyUrls);
        }
    }

    public void addStandbyUrl(StandbyUrl standbyUrl) {
        this.m_standbyUrls.add(standbyUrl);
    }

    public boolean removeStandbyUrl(StandbyUrl standbyUrl) {
        return this.m_standbyUrls.remove(standbyUrl);
    }

    public int hashCode() {
        return Objects.hash(this.m_baseUrl, this.m_standbyUrls);
    }

    public boolean equals(Object other) {
        if (!(other instanceof RwsConfiguration)) {
            return false;
        }
        RwsConfiguration castOther = (RwsConfiguration)other;
        return Objects.equals(this.m_baseUrl, castOther.m_baseUrl) && Objects.equals(this.m_standbyUrls, castOther.m_standbyUrls);
    }
}

