/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.charts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.charts.BarChart;

@XmlRootElement(name="chart-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ChartConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="bar-chart")
    private List<BarChart> barChartList = new ArrayList<BarChart>();

    public void addBarChart(BarChart vBarChart) throws IndexOutOfBoundsException {
        this.barChartList.add(vBarChart);
    }

    public void addBarChart(int index, BarChart vBarChart) throws IndexOutOfBoundsException {
        this.barChartList.add(index, vBarChart);
    }

    public Enumeration<BarChart> enumerateBarChart() {
        return Collections.enumeration(this.barChartList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChartConfiguration) {
            ChartConfiguration temp = (ChartConfiguration)obj;
            boolean equals = Objects.equals(temp.barChartList, this.barChartList);
            return equals;
        }
        return false;
    }

    public BarChart getBarChart(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.barChartList.size()) {
            throw new IndexOutOfBoundsException("getBarChart: Index value '" + index + "' not in range [0.." + (this.barChartList.size() - 1) + "]");
        }
        return this.barChartList.get(index);
    }

    public BarChart[] getBarChart() {
        BarChart[] array = new BarChart[]{};
        return this.barChartList.toArray(array);
    }

    public List<BarChart> getBarChartCollection() {
        return this.barChartList;
    }

    public int getBarChartCount() {
        return this.barChartList.size();
    }

    public int hashCode() {
        int hash = Objects.hash(this.barChartList);
        return hash;
    }

    public Iterator<BarChart> iterateBarChart() {
        return this.barChartList.iterator();
    }

    public void removeAllBarChart() {
        this.barChartList.clear();
    }

    public boolean removeBarChart(BarChart vBarChart) {
        boolean removed = this.barChartList.remove(vBarChart);
        return removed;
    }

    public BarChart removeBarChartAt(int index) {
        BarChart obj = this.barChartList.remove(index);
        return obj;
    }

    public void setBarChart(int index, BarChart vBarChart) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.barChartList.size()) {
            throw new IndexOutOfBoundsException("setBarChart: Index value '" + index + "' not in range [0.." + (this.barChartList.size() - 1) + "]");
        }
        this.barChartList.set(index, vBarChart);
    }

    public void setBarChart(BarChart[] vBarChartArray) {
        this.barChartList.clear();
        for (int i = 0; i < vBarChartArray.length; ++i) {
            this.barChartList.add(vBarChartArray[i]);
        }
    }

    public void setBarChart(List<BarChart> vBarChartList) {
        this.barChartList.clear();
        this.barChartList.addAll(vBarChartList);
    }

    public void setBarChartCollection(List<BarChart> barChartList) {
        this.barChartList = barChartList == null ? new ArrayList() : barChartList;
    }
}

