/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.beans;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.integration.api.v1.config.events.AlarmType;
import org.opennms.integration.api.v1.model.Alarm;
import org.opennms.integration.api.v1.model.DatabaseEvent;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.model.Severity;

public class AlarmBean
implements Alarm {
    private String reductionKey;
    private Integer id;
    private Node node;
    private String managedObjectInstance;
    private String managedObjectType;
    private AlarmType type;
    private Severity severity;
    private Map<String, String> attributes = new LinkedHashMap<String, String>();
    private List<Alarm> relatedAlarms = new LinkedList<Alarm>();
    private String logMessage;
    private String description;
    private Date lastEventTime;
    private Date firstEventTime;
    private DatabaseEvent lastEvent;

    public AlarmBean() {
    }

    public AlarmBean(Alarm alarm) {
        if (alarm == null) {
            return;
        }
        this.reductionKey = alarm.getReductionKey();
        this.id = alarm.getId();
        this.node = alarm.getNode();
        this.managedObjectInstance = alarm.getManagedObjectInstance();
        this.managedObjectType = alarm.getManagedObjectType();
        this.type = alarm.getType();
        this.severity = alarm.getSeverity();
        if (alarm.getAttributes() != null) {
            alarm.getAttributes().forEach((key, value) -> this.attributes.put((String)key, (String)value));
        }
        this.relatedAlarms = alarm.getRelatedAlarms();
        this.logMessage = alarm.getLogMessage();
        this.description = alarm.getDescription();
        this.lastEventTime = alarm.getLastEventTime();
        this.firstEventTime = alarm.getFirstEventTime();
        this.lastEvent = alarm.getLastEvent();
    }

    public String getReductionKey() {
        return this.reductionKey;
    }

    public void setReductionKey(String reductionKey) {
        this.reductionKey = reductionKey;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public String getManagedObjectInstance() {
        return this.managedObjectInstance;
    }

    public void setManagedObjectInstance(String managedObjectInstance) {
        this.managedObjectInstance = managedObjectInstance;
    }

    public String getManagedObjectType() {
        return this.managedObjectType;
    }

    public void setManagedObjectType(String managedObjectType) {
        this.managedObjectType = managedObjectType;
    }

    public AlarmType getType() {
        return this.type;
    }

    public void setType(AlarmType type) {
        this.type = type;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public boolean isSituation() {
        return this.getRelatedAlarms().size() > 0;
    }

    public List<Alarm> getRelatedAlarms() {
        return this.relatedAlarms;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(String logMessage) {
        this.logMessage = logMessage;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getLastEventTime() {
        return this.lastEventTime;
    }

    public void setLastEventTime(Date lastEventTime) {
        this.lastEventTime = lastEventTime;
    }

    public Date getFirstEventTime() {
        return this.firstEventTime;
    }

    public void setFirstEventTime(Date firstEventTime) {
        this.firstEventTime = firstEventTime;
    }

    public DatabaseEvent getLastEvent() {
        return this.lastEvent;
    }

    public void setLastEvent(DatabaseEvent lastEvent) {
        this.lastEvent = lastEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlarmBean alarmBean = (AlarmBean)o;
        return Objects.equals(this.reductionKey, alarmBean.reductionKey) && Objects.equals(this.id, alarmBean.id) && Objects.equals(this.node, alarmBean.node) && Objects.equals(this.managedObjectInstance, alarmBean.managedObjectInstance) && Objects.equals(this.managedObjectType, alarmBean.managedObjectType) && this.type == alarmBean.type && this.severity == alarmBean.severity && Objects.equals(this.attributes, alarmBean.attributes) && Objects.equals(this.relatedAlarms, alarmBean.relatedAlarms) && Objects.equals(this.logMessage, alarmBean.logMessage) && Objects.equals(this.description, alarmBean.description) && Objects.equals(this.lastEventTime, alarmBean.lastEventTime) && Objects.equals(this.firstEventTime, alarmBean.firstEventTime) && Objects.equals(this.lastEvent, alarmBean.lastEvent);
    }

    public int hashCode() {
        return Objects.hash(this.reductionKey, this.id, this.node, this.managedObjectInstance, this.managedObjectType, this.type, this.severity, this.attributes, this.relatedAlarms, this.logMessage, this.description, this.lastEventTime, this.firstEventTime, this.lastEvent);
    }

    public String toString() {
        return "AlarmBean{reductionKey='" + this.reductionKey + '\'' + ", id=" + this.id + ", node=" + this.node + ", managedObjectInstance='" + this.managedObjectInstance + '\'' + ", managedObjectType='" + this.managedObjectType + '\'' + ", type=" + this.type + ", severity=" + this.severity + ", attributes=" + this.attributes + ", relatedAlarms=" + this.relatedAlarms + ", logMessage='" + this.logMessage + '\'' + ", description='" + this.description + '\'' + ", lastEventTime=" + this.lastEventTime + ", firstEventTime=" + this.firstEventTime + ", lastEvent=" + this.lastEvent + '}';
    }
}

