/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.adapter.netflow5;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.netmgt.flows.api.Converter;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.telemetry.protocols.netflow.adapter.netflow5.Netflow5Flow;
import org.opennms.netmgt.telemetry.protocols.netflow.adapter.netflow5.proto.NetflowPacket;
import org.opennms.netmgt.telemetry.protocols.netflow.adapter.netflow5.proto.NetflowRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Netflow5Converter
implements Converter<NetflowPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(Netflow5Converter.class);

    public List<Flow> convert(NetflowPacket packet) {
        if (packet == null) {
            LOG.debug("Nothing to convert.");
            return Collections.emptyList();
        }
        return packet.getRecords().stream().map(record -> new Netflow5Flow(packet, (NetflowRecord)record)).collect(Collectors.toList());
    }
}

