/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.distributed.common;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

public class PropertyTree {
    private final Node root;

    private PropertyTree(Node root) {
        this.root = root;
    }

    public Optional<Node> find(Iterable<String> path) {
        Node node = this.root;
        for (String p : path) {
            if ((node = (Node)node.children.get(p)) != null) continue;
            return Optional.empty();
        }
        return Optional.of(node);
    }

    public Optional<Node> find(String ... path) {
        return this.find(Arrays.asList(path));
    }

    public String getRequiredString(String ... path) {
        return (String)this.find(path).flatMap(Node::getValue).orElseThrow(() -> new NoSuchElementException(String.format("%s must be set.", path)));
    }

    public Optional<Integer> getOptionalInteger(String ... path) {
        return this.find(path).flatMap(Node::getValue).map(Integer::parseInt);
    }

    public Map<String, String> getMap(String ... path) {
        return this.find(path).map(node -> Maps.transformValues((Map)((Node)node).children, c -> c.getValue().get())).orElseGet(Collections::emptyMap);
    }

    public Map<String, PropertyTree> getSubTrees(String ... path) {
        return this.find(path).map(node -> Maps.transformValues((Map)((Node)node).children, PropertyTree::new)).orElseGet(Collections::emptyMap);
    }

    public static PropertyTree from(Map<String, String> map) {
        Node root = new Node(Optional.empty());
        map.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEachOrdered(e -> {
            List path = Splitter.on((char)'.').splitToList((CharSequence)e.getKey());
            Node node = PropertyTree.ensure(root, path.subList(0, path.size() - 1));
            node.children.put(path.get(path.size() - 1), new Node(Optional.of(e.getValue())));
        });
        return new PropertyTree(root);
    }

    public static PropertyTree from(Dictionary<String, ?> properties) {
        return PropertyTree.from((Map<String, String>)Maps.toMap((Iterator)Iterators.forEnumeration(properties.keys()), key -> (String)properties.get(key)));
    }

    private static Node ensure(Node node, Iterable<String> path) {
        for (String p : path) {
            node = node.children.computeIfAbsent(p, key -> new Node(Optional.empty()));
        }
        return node;
    }

    public static class Node {
        private final Optional<String> value;
        private final Map<String, Node> children;

        private Node(Optional<String> value) {
            this.value = Objects.requireNonNull(value);
            this.children = Maps.newHashMap();
        }

        public Optional<String> getValue() {
            return this.value;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("children", this.children).toString();
        }
    }
}

