/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.javamail;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.javamail.JavamailProperty;
import org.opennms.netmgt.config.javamail.ReadmailHost;
import org.opennms.netmgt.config.javamail.UserAuth;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="readmail-config", namespace="http://xmlns.opennms.org/xsd/config/javamail-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="javamail-configuration.xsd")
public class ReadmailConfig
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="debug")
    private Boolean m_debug;
    @XmlAttribute(name="mail-folder")
    private String m_mailFolder;
    @XmlAttribute(name="attempt-interval")
    private Long m_attemptInterval;
    @XmlAttribute(name="delete-all-mail")
    private Boolean m_deleteAllMail;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlElement(name="javamail-property")
    private List<JavamailProperty> m_javamailProperties = new ArrayList<JavamailProperty>();
    @XmlElement(name="readmail-host", required=true)
    private ReadmailHost m_readmailHost;
    @XmlElement(name="user-auth", required=true)
    private UserAuth m_userAuth;

    public Boolean isDebug() {
        return this.m_debug == null ? Boolean.TRUE : this.m_debug;
    }

    public void setDebug(Boolean debug) {
        this.m_debug = debug;
    }

    public String getMailFolder() {
        return this.m_mailFolder == null ? "INBOX" : this.m_mailFolder;
    }

    public void setMailFolder(String mailFolder) {
        this.m_mailFolder = mailFolder;
    }

    public Long getAttemptInterval() {
        return this.m_attemptInterval == null ? 1000L : this.m_attemptInterval;
    }

    public void setAttemptInterval(Long attemptInterval) {
        this.m_attemptInterval = attemptInterval;
    }

    public Boolean isDeleteAllMail() {
        return this.m_deleteAllMail != false ? Boolean.FALSE : this.m_deleteAllMail;
    }

    public void setDeleteAllMail(Boolean deleteAllMail) {
        this.m_deleteAllMail = deleteAllMail;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public List<JavamailProperty> getJavamailProperties() {
        return this.m_javamailProperties;
    }

    public void setJavamailProperties(List<JavamailProperty> properties) {
        if (properties == this.m_javamailProperties) {
            return;
        }
        this.m_javamailProperties.clear();
        if (properties != null) {
            this.m_javamailProperties.addAll(properties);
        }
    }

    public ReadmailHost getReadmailHost() {
        return this.m_readmailHost;
    }

    public void setReadmailHost(ReadmailHost readmailHost) {
        this.m_readmailHost = ConfigUtils.assertNotNull(readmailHost, "readmail-host");
    }

    public UserAuth getUserAuth() {
        return this.m_userAuth;
    }

    public void setUserAuth(UserAuth userAuth) {
        this.m_userAuth = ConfigUtils.assertNotNull(userAuth, "user-auth");
    }

    public int hashCode() {
        return Objects.hash(this.m_debug, this.m_mailFolder, this.m_attemptInterval, this.m_deleteAllMail, this.m_name, this.m_javamailProperties, this.m_readmailHost, this.m_userAuth);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReadmailConfig) {
            ReadmailConfig that = (ReadmailConfig)obj;
            return Objects.equals(this.m_debug, that.m_debug) && Objects.equals(this.m_mailFolder, that.m_mailFolder) && Objects.equals(this.m_attemptInterval, that.m_attemptInterval) && Objects.equals(this.m_deleteAllMail, that.m_deleteAllMail) && Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_javamailProperties, that.m_javamailProperties) && Objects.equals(this.m_readmailHost, that.m_readmailHost) && Objects.equals(this.m_userAuth, that.m_userAuth);
        }
        return false;
    }
}

