/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal;

import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.netmgt.flows.classification.ClassificationEngine;
import org.opennms.netmgt.flows.classification.ClassificationRequest;

public class ThreadSafeClassificationEngine
implements ClassificationEngine {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ClassificationEngine delegate;

    public ThreadSafeClassificationEngine(ClassificationEngine delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public String classify(ClassificationRequest classificationRequest) {
        this.lock.readLock().lock();
        try {
            String string = this.delegate.classify(classificationRequest);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void reload() {
        this.lock.writeLock().lock();
        try {
            this.delegate.reload();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

