/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.health.api;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;

public class Health {
    private List<Response> responses = new ArrayList<Response>();
    private String errorMessage;

    public Health withResponse(Response response) {
        this.add(response);
        return this;
    }

    public boolean isSuccess() {
        if (this.responses.isEmpty() && this.errorMessage != null) {
            return false;
        }
        return this.responses.stream().filter(r -> r.getStatus() != Status.Success).count() == 0L;
    }

    public Optional<Response> getWorst() {
        if (this.responses.isEmpty()) {
            return Optional.empty();
        }
        return this.responses.stream().sorted(Comparator.comparingInt(response -> -1 * response.getStatus().ordinal())).findFirst();
    }

    public void add(Response response) {
        this.responses.add(response);
    }

    public void setError(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

