/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.opennms.protocols.snmp.SnmpCounter32;
import org.opennms.protocols.snmp.SnmpCounter64;
import org.opennms.protocols.snmp.SnmpEndOfMibView;
import org.opennms.protocols.snmp.SnmpGauge32;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpNoSuchInstance;
import org.opennms.protocols.snmp.SnmpNoSuchObject;
import org.opennms.protocols.snmp.SnmpNull;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpOpaque;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpV2PartyClock;

class SnmpUtil {
    static List<SnmpSyntax> m_syntaxArray = null;

    SnmpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean registerSyntax(SnmpSyntax obj) {
        boolean rc = false;
        List<SnmpSyntax> list = m_syntaxArray;
        synchronized (list) {
            boolean addIt = true;
            for (int x = 0; x < m_syntaxArray.size(); ++x) {
                SnmpSyntax tmp = m_syntaxArray.get(x);
                if (obj.typeId() != tmp.typeId()) continue;
                addIt = false;
                break;
            }
            if (addIt) {
                rc = m_syntaxArray.add(obj);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SnmpSyntax getSyntaxObject(byte asnType) {
        SnmpSyntax obj = null;
        switch (asnType) {
            case 2: {
                obj = new SnmpInt32();
                break;
            }
            case 65: {
                obj = new SnmpCounter32();
                break;
            }
            case 66: {
                obj = new SnmpGauge32();
                break;
            }
            case 70: {
                obj = new SnmpCounter64();
                break;
            }
            case 67: {
                obj = new SnmpTimeTicks();
                break;
            }
            case 4: {
                obj = new SnmpOctetString();
                break;
            }
            case 68: {
                obj = new SnmpOpaque();
                break;
            }
            case 64: {
                obj = new SnmpIPAddress();
                break;
            }
            case 6: {
                obj = new SnmpObjectId();
                break;
            }
            case 71: {
                obj = new SnmpV2PartyClock();
                break;
            }
            case -127: {
                obj = new SnmpNoSuchInstance();
                break;
            }
            case -128: {
                obj = new SnmpNoSuchObject();
                break;
            }
            case -126: {
                obj = new SnmpEndOfMibView();
                break;
            }
            case 5: {
                obj = new SnmpNull();
            }
        }
        if (obj == null) {
            List<SnmpSyntax> list = m_syntaxArray;
            synchronized (list) {
                for (int x = m_syntaxArray.size() - 1; x >= 0; --x) {
                    SnmpSyntax o = m_syntaxArray.get(x);
                    if (asnType != o.typeId()) continue;
                    obj = o.duplicate();
                    break;
                }
            }
        }
        return obj;
    }

    static void rotate(byte[] arrayBuf, int begin, int pivot, int end) {
        int pedist = end - pivot;
        int bpdist = pivot - begin;
        byte[] hold = new byte[pedist];
        System.arraycopy(arrayBuf, pivot, hold, 0, pedist);
        System.arraycopy(arrayBuf, begin, arrayBuf, begin + pedist, bpdist);
        System.arraycopy(hold, 0, arrayBuf, begin, pedist);
    }

    static void dumpHex(PrintStream out, byte[] data, int offset, int length) {
        if (offset + length > data.length) {
            return;
        }
        int cnt = 0;
        while (length > 0) {
            byte b = data[offset];
            out.print("0x");
            out.print(Integer.toHexString(b >> 4 & 0xF));
            out.print(Integer.toHexString(b & 0xF));
            out.print(" ");
            --length;
            ++offset;
            if (cnt++ % 16 != 0 || cnt == 1) continue;
            out.println("");
        }
    }

    static {
        m_syntaxArray = new ArrayList<SnmpSyntax>();
    }
}

