/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.coordination.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.opennms.features.distributed.coordination.api.DomainManager;
import org.opennms.features.distributed.coordination.api.Role;
import org.opennms.features.distributed.coordination.api.RoleChangeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDomainManager
implements DomainManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDomainManager.class);
    private Role currentRole = Role.UNKNOWN;
    private final String domain;
    private final Map<String, RoleChangeHandler> roleChangeHandlers = new HashMap<String, RoleChangeHandler>();

    protected AbstractDomainManager(String domain) {
        this.domain = Objects.requireNonNull(domain);
    }

    public final synchronized Map<String, RoleChangeHandler> getRoleChangeHandlers() {
        return Collections.unmodifiableMap(new HashMap<String, RoleChangeHandler>(this.roleChangeHandlers));
    }

    protected final synchronized void becomeActive() {
        this.currentRole = Role.ACTIVE;
        LOG.debug("Notifying all registrants of {} role", (Object)this.currentRole);
        for (Map.Entry<String, RoleChangeHandler> handler : this.roleChangeHandlers.entrySet()) {
            try {
                handler.getValue().handleRoleChange(Role.ACTIVE, this.getDomain());
            }
            catch (Exception e) {
                LOG.warn("Got exception while notifying handler {} of role {}", new Object[]{handler.getKey(), this.currentRole, e});
            }
        }
    }

    protected final synchronized void becomeStandby() {
        if (this.currentRole != Role.STANDBY) {
            this.currentRole = Role.STANDBY;
            LOG.debug("Notifying all registrants of {} role", (Object)this.currentRole);
            for (Map.Entry<String, RoleChangeHandler> handler : this.roleChangeHandlers.entrySet()) {
                try {
                    handler.getValue().handleRoleChange(Role.STANDBY, this.getDomain());
                }
                catch (Exception e) {
                    LOG.warn("Got exception while notifying handler {} of role {}", new Object[]{handler.getKey(), this.currentRole, e});
                }
            }
        }
    }

    protected final synchronized Role getCurrentRole() {
        return this.currentRole;
    }

    protected final String getDomain() {
        return this.domain;
    }

    protected abstract void onFirstRegister();

    protected abstract void onLastDeregister();

    public final synchronized void register(String id, RoleChangeHandler roleChangeHandler) {
        Objects.requireNonNull(id);
        if (!this.isAnythingRegistered()) {
            LOG.debug("Joined election pool for domain {}", (Object)this.getDomain());
            this.onFirstRegister();
        } else if (this.roleChangeHandlers.containsKey(id)) {
            throw new IllegalArgumentException(id + " is already registered");
        }
        LOG.debug("Adding {} to domain {}", (Object)id, (Object)this.getDomain());
        this.roleChangeHandlers.put(id, Objects.requireNonNull(roleChangeHandler));
        if (this.getCurrentRole() == Role.ACTIVE) {
            LOG.debug("Already ACTIVE, notifying registrant");
            roleChangeHandler.handleRoleChange(Role.ACTIVE, this.getDomain());
        }
    }

    public final synchronized void deregister(String id) {
        if (!this.roleChangeHandlers.containsKey(Objects.requireNonNull(id))) {
            throw new NoSuchElementException(id + " is not registered");
        }
        LOG.debug("Removing {} from domain {}", (Object)id, (Object)this.getDomain());
        this.roleChangeHandlers.remove(id);
        if (!this.isAnythingRegistered()) {
            if (this.currentRole == Role.ACTIVE) {
                this.currentRole = Role.UNKNOWN;
                LOG.debug("Surrendered leadership for domain {}", (Object)this.getDomain());
            }
            LOG.debug("Left election pool for domain {}", (Object)this.getDomain());
            this.onLastDeregister();
        }
    }

    public final synchronized boolean isRegistered(String id) {
        return this.roleChangeHandlers.containsKey(id);
    }

    public final synchronized boolean isAnythingRegistered() {
        return !this.roleChangeHandlers.isEmpty();
    }

    public String toString() {
        return "org.opennms.distributed.coordination.api.AbstractDomainManager{currentRole=" + this.currentRole + ", domain=" + this.domain + ", roleChangeHandlers=" + this.roleChangeHandlers + '}';
    }
}

