/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.adapter.netflow5.proto;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.telemetry.protocols.netflow.adapter.netflow5.proto.NetflowRecord;
import org.opennms.netmgt.telemetry.protocols.netflow.adapter.netflow5.proto.Utils;

public class NetflowPacket {
    public static final int VERSION = 5;
    public static final int MIN_COUNT = 1;
    public static final int MAX_COUNT = 30;
    private static final int HEADER_SIZE = 24;
    private static final int BODY_SIZE = 48;
    private final int version;
    private final int count;
    private final long sysUptime;
    private final long unixSecs;
    private final long unixNSecs;
    private final long flowSequence;
    private final short engineType;
    private final short engineId;
    private final int samplingAlgorithm;
    private final int samplingInterval;
    private final List<NetflowRecord> records = new ArrayList<NetflowRecord>();

    public NetflowPacket(byte[] bytes) {
        this(ByteBuffer.wrap(bytes));
    }

    public NetflowPacket(ByteBuffer data) {
        if (data.array().length < 24) {
            throw new IllegalArgumentException("A netflow packet must contain at least 24 bytes, but only " + data.remaining() + " have been provided.");
        }
        this.version = Utils.getInt(0, 1, data, 0);
        this.count = Utils.getInt(2, 3, data, 0);
        this.sysUptime = Utils.getLong(4, 7, data, 0);
        this.unixSecs = Utils.getLong(8, 11, data, 0);
        this.unixNSecs = Utils.getLong(12, 15, data, 0);
        this.flowSequence = Utils.getLong(16, 19, data, 0);
        this.engineType = Utils.getShort(20, 20, data, 0);
        this.engineId = Utils.getShort(21, 21, data, 0);
        this.samplingAlgorithm = (Utils.getInt(22, 23, data, 0) & 0xC000) >> 14;
        this.samplingInterval = Utils.getInt(22, 23, data, 0) & 0x3FFF;
        int theoreticallyRecordCount = (data.array().length - 24) / 48;
        int readRecordCount = Math.min(this.count, theoreticallyRecordCount);
        for (int i = 0; i < readRecordCount; ++i) {
            int offset = i * 48 + 24;
            NetflowRecord record = new NetflowRecord(data, offset);
            this.records.add(record);
        }
    }

    public boolean isValid() {
        boolean valid = this.version == 5 && this.count >= 1 && this.count <= 30 && this.getRecords().size() == this.count;
        return valid;
    }

    public NetflowRecord getRecord(int recordIndex) {
        if (recordIndex < 0 || recordIndex >= this.count) {
            throw new IndexOutOfBoundsException("Cannot access record, recordIndex must be >= 0 and < getHeader().getCount()");
        }
        return this.records.get(recordIndex);
    }

    public List<NetflowRecord> getRecords() {
        return this.records;
    }

    public int getSize() {
        return 24;
    }

    public int getVersion() {
        return this.version;
    }

    public int getCount() {
        return this.count;
    }

    public long getSysUptime() {
        return this.sysUptime;
    }

    public long getUnixSecs() {
        return this.unixSecs;
    }

    public long getUnixNSecs() {
        return this.unixNSecs;
    }

    public long getFlowSequence() {
        return this.flowSequence;
    }

    public int getEngineType() {
        return this.engineType;
    }

    public int getEngineId() {
        return this.engineId;
    }

    public int getSamplingAlgorithm() {
        return this.samplingAlgorithm;
    }

    public int getSamplingInterval() {
        return this.samplingInterval;
    }
}

