/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.util.Date;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.LldpElement;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.enlinkd.persistence.api.LldpElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.LldpLinkDao;
import org.opennms.netmgt.enlinkd.service.api.LldpTopologyService;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class LldpTopologyServiceImpl
implements LldpTopologyService {
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private LldpLinkDao m_lldpLinkDao;
    private LldpElementDao m_lldpElementDao;

    @Override
    public void delete(int nodeid) {
        this.m_lldpElementDao.deleteByNodeId(nodeid);
        this.m_lldpLinkDao.deleteByNodeId(nodeid);
        this.m_lldpElementDao.flush();
        this.m_lldpLinkDao.flush();
    }

    @Override
    public void reconcile(int nodeId, Date now) {
        LldpElement element = this.m_lldpElementDao.findByNodeId(nodeId);
        if (element != null && element.getLldpNodeLastPollTime().getTime() < now.getTime()) {
            this.m_lldpElementDao.delete(element);
            this.m_lldpElementDao.flush();
        }
        this.m_lldpLinkDao.deleteByNodeIdOlderThen(nodeId, now);
        this.m_lldpLinkDao.flush();
    }

    @Override
    public void store(int nodeId, LldpLink link) {
        if (link == null) {
            return;
        }
        this.saveLldpLink(nodeId, link);
    }

    @Transactional
    protected void saveLldpLink(final int nodeId, final LldpLink saveMe) {
        new UpsertTemplate<LldpLink, LldpLinkDao>(this.m_transactionManager, this.m_lldpLinkDao){

            @Override
            protected LldpLink query() {
                return ((LldpLinkDao)this.m_dao).get(nodeId, saveMe.getLldpLocalPortNum());
            }

            @Override
            protected LldpLink doUpdate(LldpLink dbLldpLink) {
                dbLldpLink.merge(saveMe);
                ((LldpLinkDao)this.m_dao).update(dbLldpLink);
                ((LldpLinkDao)this.m_dao).flush();
                return dbLldpLink;
            }

            @Override
            protected LldpLink doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setLldpLinkLastPollTime(saveMe.getLldpLinkCreateTime());
                ((LldpLinkDao)this.m_dao).saveOrUpdate(saveMe);
                ((LldpLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    @Transactional
    public void store(int nodeId, LldpElement element) {
        if (element == null) {
            return;
        }
        LldpElement dbelement = this.m_lldpElementDao.findByNodeId(nodeId);
        if (dbelement != null) {
            dbelement.merge(element);
            this.m_lldpElementDao.saveOrUpdate(dbelement);
            this.m_lldpElementDao.flush();
            return;
        }
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        element.setNode(node);
        element.setLldpNodeLastPollTime(element.getLldpNodeCreateTime());
        this.m_lldpElementDao.saveOrUpdate(element);
        this.m_lldpElementDao.flush();
    }

    public LldpLinkDao getLldpLinkDao() {
        return this.m_lldpLinkDao;
    }

    public void setLldpLinkDao(LldpLinkDao lldpLinkDao) {
        this.m_lldpLinkDao = lldpLinkDao;
    }

    public LldpElementDao getLldpElementDao() {
        return this.m_lldpElementDao;
    }

    public void setLldpElementDao(LldpElementDao lldpElementDao) {
        this.m_lldpElementDao = lldpElementDao;
    }
}

