/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.persistence.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.netmgt.enlinkd.model.CdpElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.CdpLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.model.IsIsElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.IsIsLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.LldpElementTopologyEntity;
import org.opennms.netmgt.enlinkd.model.LldpLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.model.OspfLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.model.SnmpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.persistence.api.TopologyEntityCache;
import org.opennms.netmgt.enlinkd.persistence.api.TopologyEntityDao;

public class TopologyEntityCacheImpl
implements TopologyEntityCache {
    private static final String CACHE_KEY = "CACHE_KEY";
    private static final String SYSTEM_PROPERTY_CACHE_DURATION = "org.opennms.ui.topology-entity-cache-duration";
    private TopologyEntityDao topologyEntityDao;
    private final LoadingCache<String, List<NodeTopologyEntity>> nodeTopologyEntities = this.createCache(() -> this.topologyEntityDao.getNodeTopologyEntities());
    private final LoadingCache<String, List<CdpLinkTopologyEntity>> cdpLinkTopologyEntities = this.createCache(() -> this.topologyEntityDao.getCdpLinkTopologyEntities());
    private final LoadingCache<String, List<IsIsLinkTopologyEntity>> isIsLinkTopologyEntities = this.createCache(() -> this.topologyEntityDao.getIsIsLinkTopologyEntities());
    private final LoadingCache<String, List<OspfLinkTopologyEntity>> ospfLinkTopologyEntities = this.createCache(() -> this.topologyEntityDao.getOspfLinkTopologyEntities());
    private final LoadingCache<String, List<LldpLinkTopologyEntity>> lldpLinkTopologyEntities = this.createCache(() -> this.topologyEntityDao.getLldpLinkTopologyEntities());
    private final LoadingCache<String, List<CdpElementTopologyEntity>> cdpElementTopologyEntities = this.createCache(() -> this.topologyEntityDao.getCdpElementTopologyEntities());
    private final LoadingCache<String, List<IsIsElementTopologyEntity>> isIsElementTopologyEntities = this.createCache(() -> this.topologyEntityDao.getIsIsElementTopologyEntities());
    private final LoadingCache<String, List<LldpElementTopologyEntity>> lldpElementTopologyEntities = this.createCache(() -> this.topologyEntityDao.getLldpElementTopologyEntities());
    private final LoadingCache<String, List<SnmpInterfaceTopologyEntity>> snmpInterfaceTopologyEntities = this.createCache(() -> this.topologyEntityDao.getSnmpTopologyEntities());
    private final LoadingCache<String, List<IpInterfaceTopologyEntity>> ipInterfaceTopologyEntities = this.createCache(() -> this.topologyEntityDao.getIpTopologyEntities());

    private <KEY, VALUE> LoadingCache<KEY, VALUE> createCache(final Supplier<VALUE> entitySupplier) {
        CacheLoader loader = new CacheLoader<KEY, VALUE>(){

            public VALUE load(KEY key) {
                return entitySupplier.get();
            }
        };
        return CacheBuilder.newBuilder().expireAfterWrite((long)this.getCacheDuration(), TimeUnit.SECONDS).build(loader);
    }

    @Override
    public List<NodeTopologyEntity> getNodeTopolgyEntities() {
        return (List)this.nodeTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    @Override
    public List<CdpLinkTopologyEntity> getCdpLinkTopologyEntities() {
        return (List)this.cdpLinkTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    @Override
    public List<OspfLinkTopologyEntity> getOspfLinkTopologyEntities() {
        return (List)this.ospfLinkTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    @Override
    public List<IsIsLinkTopologyEntity> getIsIsLinkTopologyEntities() {
        return (List)this.isIsLinkTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    @Override
    public List<LldpLinkTopologyEntity> getLldpLinkTopologyEntities() {
        return (List)this.lldpLinkTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    @Override
    public List<CdpElementTopologyEntity> getCdpElementTopologyEntities() {
        return (List)this.cdpElementTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    @Override
    public List<IsIsElementTopologyEntity> getIsIsElementTopologyEntities() {
        return (List)this.isIsElementTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    @Override
    public List<LldpElementTopologyEntity> getLldpElementTopologyEntities() {
        return (List)this.lldpElementTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    @Override
    public List<SnmpInterfaceTopologyEntity> getSnmpInterfaceTopologyEntities() {
        return (List)this.snmpInterfaceTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    @Override
    public List<IpInterfaceTopologyEntity> getIpInterfaceTopologyEntities() {
        return (List)this.ipInterfaceTopologyEntities.getUnchecked((Object)CACHE_KEY);
    }

    @Override
    public void refresh() {
        this.nodeTopologyEntities.refresh((Object)CACHE_KEY);
        this.cdpLinkTopologyEntities.refresh((Object)CACHE_KEY);
        this.isIsLinkTopologyEntities.refresh((Object)CACHE_KEY);
        this.lldpLinkTopologyEntities.refresh((Object)CACHE_KEY);
        this.cdpElementTopologyEntities.refresh((Object)CACHE_KEY);
        this.isIsElementTopologyEntities.refresh((Object)CACHE_KEY);
        this.lldpElementTopologyEntities.refresh((Object)CACHE_KEY);
        this.snmpInterfaceTopologyEntities.refresh((Object)CACHE_KEY);
        this.ipInterfaceTopologyEntities.refresh((Object)CACHE_KEY);
    }

    private int getCacheDuration() {
        return SystemProperties.getInteger((String)SYSTEM_PROPERTY_CACHE_DURATION, (int)300);
    }

    public void setTopologyEntityDao(TopologyEntityDao topologyEntityDao) {
        this.topologyEntityDao = topologyEntityDao;
    }
}

