/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.health.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.Health;
import org.opennms.core.health.api.HealthCheck;
import org.opennms.core.health.api.HealthCheckService;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class DefaultHealthCheckService
implements HealthCheckService {
    private final ExecutorService executorService = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("health-check-%d").build());
    private BundleContext bundleContext;

    public DefaultHealthCheckService(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    private List<HealthCheck> getHealthChecks() throws InvalidSyntaxException {
        Collection serviceReferences = this.bundleContext.getServiceReferences(HealthCheck.class, null);
        return serviceReferences.stream().sorted(Comparator.comparingLong(ref -> ref.getBundle().getBundleId())).map(ref -> (HealthCheck)this.bundleContext.getService(ref)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Health> performAsyncHealthCheck(Context context, Consumer<HealthCheck> onStartConsumer, Consumer<Response> onFinishConsumer) {
        CompletableFuture<Health> returnFuture = new CompletableFuture<Health>();
        Health health = new Health();
        Consumer<Response> consumer = response -> {
            health.withResponse(response);
            onFinishConsumer.accept((Response)response);
        };
        try {
            List<HealthCheck> checks = this.getHealthChecks();
            if (checks == null || checks.isEmpty()) {
                health.setError("No Health Checks available");
            } else {
                this.runChecks(context, checks, onStartConsumer, consumer);
            }
            returnFuture.complete(health);
        }
        catch (InvalidSyntaxException ex) {
            try {
                health.setError("Error while performing health checks: " + ex.getMessage());
                returnFuture.complete(health);
            }
            catch (Throwable throwable) {
                returnFuture.complete(health);
                throw throwable;
            }
        }
        return returnFuture;
    }

    private void runChecks(Context context, List<HealthCheck> checks, Consumer<HealthCheck> onStartConsumer, Consumer<Response> onFinishConsumer) {
        Future<Response> currentFuture = null;
        for (HealthCheck check : checks) {
            try {
                if (onStartConsumer != null) {
                    onStartConsumer.accept(check);
                }
                currentFuture = this.executorService.submit(() -> {
                    try {
                        Response response = check.perform(context);
                        if (response == null) {
                            return new Response(Status.Unknown);
                        }
                        return response;
                    }
                    catch (Exception ex) {
                        return new Response(ex);
                    }
                });
                Response response = currentFuture.get(context.getTimeout(), TimeUnit.MILLISECONDS);
                if (onFinishConsumer == null) continue;
                onFinishConsumer.accept(response);
            }
            catch (TimeoutException timeoutException) {
                if (currentFuture != null) {
                    currentFuture.cancel(true);
                }
                onFinishConsumer.accept(new Response(Status.Timeout, "Health Check did not finish within " + context.getTimeout() + " ms"));
            }
            catch (Exception ex) {
                if (currentFuture != null) {
                    currentFuture.cancel(true);
                }
                onFinishConsumer.accept(new Response(ex));
            }
        }
    }
}

