/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.adapters.netflow.v5.proto;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.opennms.core.utils.InetAddressUtils;

public class Utils {
    static int getInt(int startIndex, int endIndex, ByteBuffer data, int offset) {
        BigInteger bigInteger = Utils.getBigInteger(startIndex, endIndex, data, offset);
        return bigInteger.intValue();
    }

    static short getShort(int startIndex, int endIndex, ByteBuffer data, int offset) {
        BigInteger bigInteger = Utils.getBigInteger(startIndex, endIndex, data, offset);
        return bigInteger.shortValue();
    }

    static long getLong(int startIndex, int endIndex, ByteBuffer data, int offset) {
        BigInteger bigInteger = Utils.getBigInteger(startIndex, endIndex, data, offset);
        return bigInteger.longValue();
    }

    static String getInetAddress(int startIndex, int endIndex, ByteBuffer data, int offset) {
        byte[] bytes = Utils.getBytes(data, offset + startIndex, endIndex - startIndex + 1);
        return InetAddressUtils.toIpAddrString((byte[])bytes);
    }

    private static BigInteger getBigInteger(int startIndex, int endIndex, ByteBuffer data, int offset) {
        byte[] bytes = Utils.getBytes(data, offset + startIndex, endIndex - startIndex + 1);
        return new BigInteger(1, bytes);
    }

    private static byte[] getBytes(ByteBuffer data, int offset, int length) {
        return Arrays.copyOfRange(data.array(), offset, offset + length);
    }
}

