/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.kafka.server.config;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import org.opennms.core.ipc.sink.kafka.server.config.KafkaConfigProvider;
import org.osgi.service.cm.ConfigurationAdmin;

public class OsgiKafkaConfigProvider
implements KafkaConfigProvider {
    private final String groupId;
    private final ConfigurationAdmin configAdmin;

    public OsgiKafkaConfigProvider(String groupId, ConfigurationAdmin configAdmin) {
        this.groupId = Objects.requireNonNull(groupId);
        this.configAdmin = Objects.requireNonNull(configAdmin);
    }

    @Override
    public synchronized Properties getProperties() {
        Properties kafkaConfig = new Properties();
        kafkaConfig.put("group.id", this.groupId);
        try {
            Dictionary properties = this.configAdmin.getConfiguration("org.opennms.core.ipc.sink.kafka.consumer").getProperties();
            if (properties != null) {
                Enumeration keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    kafkaConfig.put(key, properties.get(key));
                }
            }
            return kafkaConfig;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load properties", e);
        }
    }
}

