/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.junit.runner;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.opennms.netmgt.junit.runner.TestClassRunnerForSelenium;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumJUnitRunner
extends Suite {
    private final List<Runner> m_runners = new ArrayList<Runner>();

    public SeleniumJUnitRunner(Class<?> testClass) throws InitializationError {
        super(testClass, Collections.emptyList());
        this.m_runners.add((Runner)new TestClassRunnerForSelenium(this.getTestClass().getJavaClass(), this.getBaseUrlAnnotation(testClass), this.getTimeoutAnnotation(testClass)));
    }

    private int getTimeoutAnnotation(Class<?> testClass) {
        TimeoutInSeconds timeout = testClass.getAnnotation(TimeoutInSeconds.class);
        if (timeout == null) {
            return 3;
        }
        return timeout.timeout();
    }

    private String getBaseUrlAnnotation(Class<?> klass) {
        BaseUrl baseUrl = klass.getAnnotation(BaseUrl.class);
        if (baseUrl == null) {
            return "";
        }
        return baseUrl.url();
    }

    protected List<Runner> getChildren() {
        return this.m_runners;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TimeoutInSeconds {
        public int timeout();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface BaseUrl {
        public String url();
    }
}

