/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.rest.internal;

import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchService;
import org.opennms.netmgt.search.rest.SearchRestService;

public class SearchRestServiceImpl
implements SearchRestService {
    private final SearchService searchService;

    public SearchRestServiceImpl(SearchService searchService) {
        this.searchService = Objects.requireNonNull(searchService);
    }

    @Override
    public Response query(SecurityContext securityContext, String context, String query, int limit) {
        SearchQuery searchQuery = new SearchQuery(query);
        searchQuery.setPrincipal(securityContext.getUserPrincipal());
        searchQuery.setUserInRoleFunction(arg_0 -> ((SecurityContext)securityContext).isUserInRole(arg_0));
        searchQuery.setContext(context);
        searchQuery.setMaxResults(limit < 0 ? 0 : limit);
        List searchResult = this.searchService.query(searchQuery);
        if (searchResult.isEmpty()) {
            return Response.noContent().build();
        }
        JSONArray jsonResult = new JSONArray();
        for (SearchResult eachResult : searchResult) {
            jsonResult.put((Object)new JSONObject((Object)eachResult));
        }
        return Response.ok().entity((Object)jsonResult.toString()).build();
    }
}

