/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.node;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.Match;
import org.opennms.netmgt.search.api.QueryUtils;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.providers.SearchResultItemBuilder;

public class NodeLocationSearchProvider
implements SearchProvider {
    private final NodeDao nodeDao;

    public NodeLocationSearchProvider(NodeDao nodeDao) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
    }

    public SearchContext getContext() {
        return Contexts.Node;
    }

    public SearchResult query(SearchQuery query) {
        String input = query.getInput();
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsNode.class).alias("location", "location", Alias.JoinType.INNER_JOIN).ilike("location.locationName", QueryUtils.ilike((String)input)).distinct();
        int totalCount = this.nodeDao.countMatching(criteriaBuilder.toCriteria());
        List matchingNodes = this.nodeDao.findMatching(criteriaBuilder.orderBy("label").limit(Integer.valueOf(query.getMaxResults())).toCriteria());
        List searchResultItems = matchingNodes.stream().map(node -> {
            SearchResultItem searchResultItem = new SearchResultItemBuilder().withOnmsNode((OnmsNode)node).build();
            searchResultItem.addMatch(new Match("location.name", "Node Location", node.getLocation().getLocationName()));
            return searchResultItem;
        }).collect(Collectors.toList());
        SearchResult searchResult = new SearchResult(Contexts.Node).withResults(searchResultItems).withMore(totalCount > searchResultItems.size());
        return searchResult;
    }
}

