/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.node;

import java.net.InetAddress;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.Match;
import org.opennms.netmgt.search.api.QueryUtils;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.providers.SearchResultItemBuilder;

public class NodeIpSearchProvider
implements SearchProvider {
    private final NodeDao nodeDao;

    public NodeIpSearchProvider(NodeDao nodeDao) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
    }

    public SearchContext getContext() {
        return Contexts.Node;
    }

    public SearchResult query(SearchQuery query) {
        String input = query.getInput();
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsNode.class).alias("ipInterfaces", "ipInterfaces").ilike("ipInterfaces.ipAddress", QueryUtils.ilike((String)input)).distinct();
        int totalCount = this.nodeDao.countMatching(criteriaBuilder.toCriteria());
        Criteria criteria = criteriaBuilder.orderBy("label").distinct().limit(Integer.valueOf(query.getMaxResults())).toCriteria();
        List matchingNodes = this.nodeDao.findMatching(criteria);
        List searchResultItems = matchingNodes.stream().map(node -> {
            SearchResultItem searchResultItem = new SearchResultItemBuilder().withOnmsNode((OnmsNode)node).build();
            node.getIpInterfaces().stream().filter(ipInterface -> QueryUtils.matches((String)ipInterface.getIpAddress().toString(), (String)input)).forEach(ipInterface -> searchResultItem.addMatch(new Match("ipInterface.ipAddress", "IP Address", InetAddressUtils.str((InetAddress)ipInterface.getIpAddress()))));
            return searchResultItem;
        }).collect(Collectors.toList());
        SearchResult searchResult = new SearchResult(Contexts.Node).withMore(totalCount > searchResultItems.size()).withResults(searchResultItems);
        return searchResult;
    }
}

