/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.node;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.Matcher;
import org.opennms.netmgt.search.api.QueryUtils;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.providers.SearchResultItemBuilder;

public class NodeGeolocationSearchProvider
implements SearchProvider {
    private final NodeDao nodeDao;

    public NodeGeolocationSearchProvider(NodeDao nodeDao) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
    }

    public SearchContext getContext() {
        return Contexts.Node;
    }

    public SearchResult query(SearchQuery query) {
        String input = query.getInput();
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsNode.class).alias("assetRecord", "assetRecord").alias("assetRecord.geolocation", "geolocation").and(new Restriction[]{Restrictions.isNotNull((String)"assetRecord"), Restrictions.isNotNull((String)"assetRecord.geolocation"), Restrictions.or((Restriction[])new Restriction[]{Restrictions.ilike((String)"assetRecord.geolocation.address1", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.geolocation.address2", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.geolocation.city", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.geolocation.state", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.geolocation.zip", (Object)QueryUtils.ilike((String)input)), Restrictions.ilike((String)"assetRecord.geolocation.country", (Object)QueryUtils.ilike((String)input))})}).distinct();
        int totalCount = this.nodeDao.countMatching(criteriaBuilder.toCriteria());
        Criteria criteria = criteriaBuilder.orderBy("label").limit(Integer.valueOf(query.getMaxResults())).toCriteria();
        List matchingNodes = this.nodeDao.findMatching(criteria);
        List results = matchingNodes.stream().map(node -> {
            SearchResultItem result = new SearchResultItemBuilder().withOnmsNode((OnmsNode)node).build();
            OnmsGeolocation geolocation = node.getAssetRecord().getGeolocation();
            ArrayList matcherList = Lists.newArrayList((Object[])new Matcher[]{new Matcher("Country", geolocation.getCountry()), new Matcher("City", geolocation.getCity()), new Matcher("State", geolocation.getState()), new Matcher("Zip", geolocation.getZip()), new Matcher("Address 1", geolocation.getAddress1()), new Matcher("Address 2", geolocation.getAddress2())});
            result.addMatches((List)matcherList, input);
            return result;
        }).collect(Collectors.toList());
        SearchResult result = new SearchResult(Contexts.Node).withResults(results).withMore(totalCount > results.size());
        return result;
    }
}

