/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.search.api.Match;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.providers.node.NodeRef;

public class SearchResultItemBuilder {
    private final SearchResultItem searchResultItem = new SearchResultItem();

    public SearchResultItemBuilder withOnmsNode(OnmsNode node) {
        Objects.requireNonNull(node);
        NodeRef nodeRef = new NodeRef(node);
        this.searchResultItem.setIdentifier(nodeRef.asString());
        this.searchResultItem.setUrl("element/node.jsp?node=" + node.getId());
        this.searchResultItem.setLabel(node.getLabel());
        this.searchResultItem.setProperties((Map)ImmutableMap.builder().put((Object)"label", (Object)node.getLabel()).put((Object)"foreignId", (Object)node.getForeignId()).put((Object)"foreignSource", (Object)node.getForeignSource()).build());
        return this;
    }

    public SearchResultItemBuilder withMatch(String id, String label, String value) {
        this.searchResultItem.addMatch(new Match(id, label, value));
        return this;
    }

    public SearchResultItemBuilder withWeight(int weight) {
        this.searchResultItem.setWeight(weight);
        return this;
    }

    public SearchResultItem build() {
        return this.searchResultItem;
    }
}

